/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.util;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.citydb.plugins.spreadsheet_gen.util.ClipboardHandler;
import org.citygml4j.model.citygml.CityGMLClass;

public class Util {
    public static ResourceBundle I18N;
    public static final String NUMBER_COLUMN_KEY = "NUMBER_COLUMN_KEY";
    public static int NUMBER_COLUMN_VALUE;
    public static final String STRING_COLUMN_KEY = "STRING_COLUMN_KEY";
    public static int STRING_COLUMN_VALUE;
    public static ClipboardHandler clipboard;
    public static final HashMap<String, Integer> _3DCITYDB_TABLES_AND_COLUMNS;

    public static GridBagConstraints setConstraints(int n, int n2, double d, double d2, int n3, int n4, int n5, int n6, int n7) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n3;
        gridBagConstraints.insets = new Insets(n4, n5, n6, n7);
        return gridBagConstraints;
    }

    public static GridBagConstraints setConstraints(int n, int n2, int n3, double d, double d2, int n4, int n5, int n6, int n7, int n8) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n4;
        gridBagConstraints.anchor = n;
        gridBagConstraints.insets = new Insets(n5, n6, n7, n8);
        return gridBagConstraints;
    }

    public static boolean checkWorkspaceTimestamp(String string) {
        boolean bl = true;
        if (string.length() > 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
            simpleDateFormat.setLenient(false);
            try {
                simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                bl = false;
            }
        }
        return bl;
    }

    public static CityGMLClass classId2cityObject(int n) {
        CityGMLClass cityGMLClass = CityGMLClass.UNDEFINED;
        switch (n) {
            case 4: {
                cityGMLClass = CityGMLClass.LAND_USE;
                break;
            }
            case 21: {
                cityGMLClass = CityGMLClass.CITY_FURNITURE;
                break;
            }
            case 26: {
                cityGMLClass = CityGMLClass.BUILDING;
                break;
            }
            case 9: {
                cityGMLClass = CityGMLClass.WATER_BODY;
                break;
            }
            case 8: {
                cityGMLClass = CityGMLClass.PLANT_COVER;
                break;
            }
            case 7: {
                cityGMLClass = CityGMLClass.SOLITARY_VEGETATION_OBJECT;
                break;
            }
            case 42: {
                cityGMLClass = CityGMLClass.TRANSPORTATION_COMPLEX;
                break;
            }
            case 43: {
                cityGMLClass = CityGMLClass.TRACK;
                break;
            }
            case 44: {
                cityGMLClass = CityGMLClass.RAILWAY;
                break;
            }
            case 45: {
                cityGMLClass = CityGMLClass.ROAD;
                break;
            }
            case 46: {
                cityGMLClass = CityGMLClass.SQUARE;
                break;
            }
            case 5: {
                cityGMLClass = CityGMLClass.GENERIC_CITY_OBJECT;
                break;
            }
            case 23: {
                cityGMLClass = CityGMLClass.CITY_OBJECT_GROUP;
                break;
            }
            case 14: {
                cityGMLClass = CityGMLClass.RELIEF_FEATURE;
                break;
            }
            case 16: {
                cityGMLClass = CityGMLClass.TIN_RELIEF;
                break;
            }
            case 17: {
                cityGMLClass = CityGMLClass.MASSPOINT_RELIEF;
                break;
            }
            case 18: {
                cityGMLClass = CityGMLClass.BREAKLINE_RELIEF;
                break;
            }
            case 19: {
                cityGMLClass = CityGMLClass.RASTER_RELIEF;
            }
        }
        return cityGMLClass;
    }

    static {
        NUMBER_COLUMN_VALUE = 1;
        STRING_COLUMN_VALUE = 2;
        clipboard = new ClipboardHandler();
        _3DCITYDB_TABLES_AND_COLUMNS = new HashMap<String, Integer>(){
            {
                this.put(Util.STRING_COLUMN_KEY, STRING_COLUMN_VALUE);
                this.put(Util.NUMBER_COLUMN_KEY, NUMBER_COLUMN_VALUE);
                this.put("BUILDING__ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__BUILDING_PARENT_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__BUILDING_ROOT_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__CLASS", STRING_COLUMN_VALUE);
                this.put("BUILDING__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING__FUNCTION", STRING_COLUMN_VALUE);
                this.put("BUILDING__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING__USAGE", STRING_COLUMN_VALUE);
                this.put("BUILDING__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING__YEAR_OF_CONSTRUCTION", STRING_COLUMN_VALUE);
                this.put("BUILDING__YEAR_OF_DEMOLITION", STRING_COLUMN_VALUE);
                this.put("BUILDING__ROOF_TYPE", STRING_COLUMN_VALUE);
                this.put("BUILDING__ROOF_TYPE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING__MEASURED_HEIGHT", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__MEASURED_HEIGHT_UNIT", STRING_COLUMN_VALUE);
                this.put("BUILDING__STOREYS_ABOVE_GROUND", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__STOREYS_BELOW_GROUND", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__STOREY_HEIGHTS_ABOVE_GROUND", STRING_COLUMN_VALUE);
                this.put("BUILDING__STOREY_HEIGHTS_AG_UNIT", STRING_COLUMN_VALUE);
                this.put("BUILDING__STOREY_HEIGHTS_BELOW_GROUND", STRING_COLUMN_VALUE);
                this.put("BUILDING__STOREY_HEIGHTS_BG_UNIT", STRING_COLUMN_VALUE);
                this.put("BUILDING__LOD1_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BUILDING__LOD2_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BUILDING__LOD3_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BUILDING__LOD4_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BUILDING__LOD2_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("BUILDING__LOD3_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("BUILDING__LOD4_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("BUILDING__LOD0_FOOTPRINT_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__LOD0_ROOFPRINT_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__LOD1_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__LOD1_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__LOD2_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__LOD3_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING__LOD4_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERALIZATION__CITYOBJECT_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERALIZATION__GENERALIZES_TO_ID", NUMBER_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__ID", NUMBER_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__GMLID", STRING_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__PARENT_ID", NUMBER_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__ROOT_ID", NUMBER_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__IS_SOLID", STRING_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__IS_COMPOSITE", STRING_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__IS_TRIANGULATED", STRING_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__IS_XLINK", STRING_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__IS_REVERSE", STRING_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__GEOMETRY", STRING_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__SOLID_GEOMETRY", STRING_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__IMPLICIT_GEOMETRY", STRING_COLUMN_VALUE);
                this.put("SURFACE_GEOMETRY__CITYOBJECT_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("TUNNEL_OPENING__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__ADDRESS_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_OPENING__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__CLASS", STRING_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__FUNCTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__USAGE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__BRIDGE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_ROOM__LOD4_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__CLASS", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__FUNCTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__USAGE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__BRIDGE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD1_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD2_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD3_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD4_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD1_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD2_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD3_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD1_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD2_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD3_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD4_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD1_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD2_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD1_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD2_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD1_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD2_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_CONSTR_ELEMENT__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("OBJECTCLASS__ID", NUMBER_COLUMN_VALUE);
                this.put("OBJECTCLASS__CLASSNAME", STRING_COLUMN_VALUE);
                this.put("OBJECTCLASS__SUPERCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("ADDRESS_TO_BRIDGE__BRIDGE_ID", NUMBER_COLUMN_VALUE);
                this.put("ADDRESS_TO_BRIDGE__ADDRESS_ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__CLASS", STRING_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__FUNCTION", STRING_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__USAGE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("CITYOBJECTGROUP__PARENT_CITYOBJECT_ID", NUMBER_COLUMN_VALUE);
                this.put("EXTERNAL_REFERENCE__ID", NUMBER_COLUMN_VALUE);
                this.put("EXTERNAL_REFERENCE__INFOSYS", STRING_COLUMN_VALUE);
                this.put("EXTERNAL_REFERENCE__NAME", STRING_COLUMN_VALUE);
                this.put("EXTERNAL_REFERENCE__URI", STRING_COLUMN_VALUE);
                this.put("EXTERNAL_REFERENCE__CITYOBJECT_ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__CLASS", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__FUNCTION", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__USAGE", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__SPECIES", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__SPECIES_CODESPACE", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__HEIGHT", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__HEIGHT_UNIT", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__TRUNC_DIAMETER", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__TRUNC_DIAMETER_UNIT", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__CROWN_DIAMETER", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__CROWN_DIAMETER_UNIT", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD1_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD2_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD3_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD1_OTHER_GEOM", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD2_OTHER_GEOM", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD3_OTHER_GEOM", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD4_OTHER_GEOM", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD1_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD2_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD1_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD2_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD1_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD2_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("SOLITARY_VEGETAT_OBJECT__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("TEXTUREPARAM__SURFACE_GEOMETRY_ID", NUMBER_COLUMN_VALUE);
                this.put("TEXTUREPARAM__IS_TEXTURE_PARAMETRIZATION", STRING_COLUMN_VALUE);
                this.put("TEXTUREPARAM__WORLD_TO_TEXTURE", STRING_COLUMN_VALUE);
                this.put("TEXTUREPARAM__TEXTURE_COORDINATES", STRING_COLUMN_VALUE);
                this.put("TEXTUREPARAM__SURFACE_DATA_ID", NUMBER_COLUMN_VALUE);
                this.put("OPENING__ID", NUMBER_COLUMN_VALUE);
                this.put("OPENING__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("OPENING__ADDRESS_ID", NUMBER_COLUMN_VALUE);
                this.put("OPENING__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("OPENING__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("OPENING__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("OPENING__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("OPENING__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("OPENING__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("OPENING__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("OPENING__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_THEMATIC_SURFACE__ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_THEMATIC_SURFACE__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_THEMATIC_SURFACE__BRIDGE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_THEMATIC_SURFACE__BRIDGE_ROOM_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_THEMATIC_SURFACE__BRIDGE_INSTALLATION_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_THEMATIC_SURFACE__BRIDGE_CONSTR_ELEMENT_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_THEMATIC_SURFACE__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_THEMATIC_SURFACE__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_THEMATIC_SURFACE__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("RELIEF_FEATURE__ID", NUMBER_COLUMN_VALUE);
                this.put("RELIEF_FEATURE__LOD", NUMBER_COLUMN_VALUE);
                this.put("APPEARANCE__ID", NUMBER_COLUMN_VALUE);
                this.put("APPEARANCE__GMLID", STRING_COLUMN_VALUE);
                this.put("APPEARANCE__NAME", STRING_COLUMN_VALUE);
                this.put("APPEARANCE__NAME_CODESPACE", STRING_COLUMN_VALUE);
                this.put("APPEARANCE__DESCRIPTION", STRING_COLUMN_VALUE);
                this.put("APPEARANCE__THEME", STRING_COLUMN_VALUE);
                this.put("APPEARANCE__CITYMODEL_ID", NUMBER_COLUMN_VALUE);
                this.put("APPEARANCE__CITYOBJECT_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__CLASS", STRING_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__FUNCTION", STRING_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__USAGE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__TUNNEL_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_HOLLOW_SPACE__LOD4_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("DATABASE_SRS__SRID", STRING_COLUMN_VALUE);
                this.put("DATABASE_SRS__GML_SRS_NAME", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__PARENT_GENATTRIB_ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__ROOT_GENATTRIB_ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__ATTRNAME", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__DATATYPE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__STRVAL", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__INTVAL", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__REALVAL", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__URIVAL", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__DATEVAL", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__GEOMVAL", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__BLOBVAL", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__UNIT", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__GENATTRIBSET_CODESPACE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__SURFACE_GEOMETRY_ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT_GENERICATTRIB__CITYOBJECT_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBODY__ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBODY__CLASS", STRING_COLUMN_VALUE);
                this.put("WATERBODY__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("WATERBODY__FUNCTION", STRING_COLUMN_VALUE);
                this.put("WATERBODY__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("WATERBODY__USAGE", STRING_COLUMN_VALUE);
                this.put("WATERBODY__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("WATERBODY__LOD0_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("WATERBODY__LOD1_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("WATERBODY__LOD0_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBODY__LOD1_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBODY__LOD1_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBODY__LOD2_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBODY__LOD3_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBODY__LOD4_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("SURFACE_DATA__ID", NUMBER_COLUMN_VALUE);
                this.put("SURFACE_DATA__GMLID", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__NAME", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__NAME_CODESPACE", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__DESCRIPTION", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__IS_FRONT", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("SURFACE_DATA__X3D_SHININESS", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__X3D_TRANSPARENCY", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__X3D_AMBIENT_INTENSITY", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__X3D_SPECULAR_COLOR", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__X3D_DIFFUSE_COLOR", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__X3D_EMISSIVE_COLOR", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__X3D_IS_SMOOTH", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__TEX_IMAGE_ID", NUMBER_COLUMN_VALUE);
                this.put("SURFACE_DATA__TEX_TEXTURE_TYPE", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__TEX_WRAP_MODE", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__TEX_BORDER_COLOR", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__GT_PREFER_WORLDFILE", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__GT_ORIENTATION", STRING_COLUMN_VALUE);
                this.put("SURFACE_DATA__GT_REFERENCE_POINT", STRING_COLUMN_VALUE);
                this.put("TEX_IMAGE__ID", NUMBER_COLUMN_VALUE);
                this.put("TEX_IMAGE__TEX_IMAGE_URI", STRING_COLUMN_VALUE);
                this.put("TEX_IMAGE__TEX_IMAGE_DATA", STRING_COLUMN_VALUE);
                this.put("TEX_IMAGE__TEX_MIME_TYPE", STRING_COLUMN_VALUE);
                this.put("TEX_IMAGE__TEX_MIME_TYPE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE__ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__BRIDGE_PARENT_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__BRIDGE_ROOT_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__CLASS", STRING_COLUMN_VALUE);
                this.put("BRIDGE__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE__FUNCTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE__USAGE", STRING_COLUMN_VALUE);
                this.put("BRIDGE__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE__YEAR_OF_CONSTRUCTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE__YEAR_OF_DEMOLITION", STRING_COLUMN_VALUE);
                this.put("BRIDGE__IS_MOVABLE", STRING_COLUMN_VALUE);
                this.put("BRIDGE__LOD1_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE__LOD2_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE__LOD3_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE__LOD4_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE__LOD2_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("BRIDGE__LOD3_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("BRIDGE__LOD4_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("BRIDGE__LOD1_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__LOD1_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__LOD2_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__LOD3_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE__LOD4_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__CLASS", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__FUNCTION", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__USAGE", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD1_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD2_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD3_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD4_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD1_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD2_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD3_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD1_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD2_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD3_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD4_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD1_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD2_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD1_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD2_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD1_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD2_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("CITY_FURNITURE__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("IMPLICIT_GEOMETRY__MIME_TYPE", STRING_COLUMN_VALUE);
                this.put("IMPLICIT_GEOMETRY__REFERENCE_TO_LIBRARY", STRING_COLUMN_VALUE);
                this.put("IMPLICIT_GEOMETRY__LIBRARY_OBJECT", STRING_COLUMN_VALUE);
                this.put("IMPLICIT_GEOMETRY__RELATIVE_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("IMPLICIT_GEOMETRY__RELATIVE_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BRIDGE_OPEN_TO_THEM_SRF__BRIDGE_OPENING_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_OPEN_TO_THEM_SRF__BRIDGE_THEMATIC_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("GROUP_TO_CITYOBJECT__CITYOBJECT_ID", NUMBER_COLUMN_VALUE);
                this.put("GROUP_TO_CITYOBJECT__CITYOBJECTGROUP_ID", NUMBER_COLUMN_VALUE);
                this.put("GROUP_TO_CITYOBJECT__ROLE", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__CLASS", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__FUNCTION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__USAGE", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD0_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD1_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD2_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD3_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD4_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD0_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD1_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD2_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD3_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD0_OTHER_GEOM", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD1_OTHER_GEOM", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD2_OTHER_GEOM", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD3_OTHER_GEOM", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD4_OTHER_GEOM", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD0_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD1_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD2_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD0_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD1_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD2_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD0_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD1_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD2_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("GENERIC_CITYOBJECT__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__ID", NUMBER_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__CLASS", STRING_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__FUNCTION", STRING_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__USAGE", STRING_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__LOD0_NETWORK", STRING_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__LOD1_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TRANSPORTATION_COMPLEX__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__CLASS", STRING_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__FUNCTION", STRING_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__USAGE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__TUNNEL_HOLLOW_SPACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__LOD4_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("TUNNEL_FURNITURE__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("TUNNEL__ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__TUNNEL_PARENT_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__TUNNEL_ROOT_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__CLASS", STRING_COLUMN_VALUE);
                this.put("TUNNEL__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL__FUNCTION", STRING_COLUMN_VALUE);
                this.put("TUNNEL__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL__USAGE", STRING_COLUMN_VALUE);
                this.put("TUNNEL__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL__YEAR_OF_CONSTRUCTION", STRING_COLUMN_VALUE);
                this.put("TUNNEL__YEAR_OF_DEMOLITION", STRING_COLUMN_VALUE);
                this.put("TUNNEL__LOD1_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("TUNNEL__LOD2_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("TUNNEL__LOD3_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("TUNNEL__LOD4_TERRAIN_INTERSECTION", STRING_COLUMN_VALUE);
                this.put("TUNNEL__LOD2_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("TUNNEL__LOD3_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("TUNNEL__LOD4_MULTI_CURVE", STRING_COLUMN_VALUE);
                this.put("TUNNEL__LOD1_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__LOD1_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__LOD2_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__LOD3_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL__LOD4_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("ADDRESS_TO_BUILDING__BUILDING_ID", NUMBER_COLUMN_VALUE);
                this.put("ADDRESS_TO_BUILDING__ADDRESS_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__CLASS", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__FUNCTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__USAGE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__BRIDGE_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__BRIDGE_ROOM_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD2_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD3_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD2_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD3_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD4_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD2_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD2_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD2_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_INSTALLATION__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("WATERBOUNDARY_SURFACE__ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBOUNDARY_SURFACE__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBOUNDARY_SURFACE__WATER_LEVEL", STRING_COLUMN_VALUE);
                this.put("WATERBOUNDARY_SURFACE__WATER_LEVEL_CODESPACE", STRING_COLUMN_VALUE);
                this.put("WATERBOUNDARY_SURFACE__LOD2_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBOUNDARY_SURFACE__LOD3_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBOUNDARY_SURFACE__LOD4_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_OPEN_TO_THEM_SRF__TUNNEL_OPENING_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_OPEN_TO_THEM_SRF__TUNNEL_THEMATIC_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("ROOM__ID", NUMBER_COLUMN_VALUE);
                this.put("ROOM__CLASS", STRING_COLUMN_VALUE);
                this.put("ROOM__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("ROOM__FUNCTION", STRING_COLUMN_VALUE);
                this.put("ROOM__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("ROOM__USAGE", STRING_COLUMN_VALUE);
                this.put("ROOM__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("ROOM__BUILDING_ID", NUMBER_COLUMN_VALUE);
                this.put("ROOM__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("ROOM__LOD4_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBOD_TO_WATERBND_SRF__WATERBOUNDARY_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("WATERBOD_TO_WATERBND_SRF__WATERBODY_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__CLASS", STRING_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__FUNCTION", STRING_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__USAGE", STRING_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__ROOM_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__LOD4_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BUILDING_FURNITURE__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("PLANT_COVER__ID", NUMBER_COLUMN_VALUE);
                this.put("PLANT_COVER__CLASS", STRING_COLUMN_VALUE);
                this.put("PLANT_COVER__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("PLANT_COVER__FUNCTION", STRING_COLUMN_VALUE);
                this.put("PLANT_COVER__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("PLANT_COVER__USAGE", STRING_COLUMN_VALUE);
                this.put("PLANT_COVER__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("PLANT_COVER__AVERAGE_HEIGHT", NUMBER_COLUMN_VALUE);
                this.put("PLANT_COVER__AVERAGE_HEIGHT_UNIT", STRING_COLUMN_VALUE);
                this.put("PLANT_COVER__LOD1_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("PLANT_COVER__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("PLANT_COVER__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("PLANT_COVER__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("PLANT_COVER__LOD1_MULTI_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("PLANT_COVER__LOD2_MULTI_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("PLANT_COVER__LOD3_MULTI_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("PLANT_COVER__LOD4_MULTI_SOLID_ID", NUMBER_COLUMN_VALUE);
                this.put("RELIEF_COMPONENT__ID", NUMBER_COLUMN_VALUE);
                this.put("RELIEF_COMPONENT__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("RELIEF_COMPONENT__LOD", NUMBER_COLUMN_VALUE);
                this.put("RELIEF_COMPONENT__EXTENT", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT_MEMBER__CITYMODEL_ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT_MEMBER__CITYOBJECT_ID", NUMBER_COLUMN_VALUE);
                this.put("ADDRESS__ID", NUMBER_COLUMN_VALUE);
                this.put("ADDRESS__STREET", STRING_COLUMN_VALUE);
                this.put("ADDRESS__HOUSE_NUMBER", STRING_COLUMN_VALUE);
                this.put("ADDRESS__PO_BOX", STRING_COLUMN_VALUE);
                this.put("ADDRESS__ZIP_CODE", STRING_COLUMN_VALUE);
                this.put("ADDRESS__CITY", STRING_COLUMN_VALUE);
                this.put("ADDRESS__STATE", STRING_COLUMN_VALUE);
                this.put("ADDRESS__COUNTRY", STRING_COLUMN_VALUE);
                this.put("ADDRESS__MULTI_POINT", STRING_COLUMN_VALUE);
                this.put("ADDRESS__XAL_SOURCE", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__ID", NUMBER_COLUMN_VALUE);
                this.put("CITYMODEL__GMLID", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__NAME", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__NAME_CODESPACE", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__DESCRIPTION", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__ENVELOPE", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__CREATION_DATE", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__TERMINATION_DATE", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__LAST_MODIFICATION_DATE", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__UPDATING_PERSON", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__REASON_FOR_UPDATE", STRING_COLUMN_VALUE);
                this.put("CITYMODEL__LINEAGE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__CLASS", STRING_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__FUNCTION", STRING_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__USAGE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__BRIDGE_ROOM_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__LOD4_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BRIDGE_FURNITURE__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("THEMATIC_SURFACE__ID", NUMBER_COLUMN_VALUE);
                this.put("THEMATIC_SURFACE__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("THEMATIC_SURFACE__BUILDING_ID", NUMBER_COLUMN_VALUE);
                this.put("THEMATIC_SURFACE__ROOM_ID", NUMBER_COLUMN_VALUE);
                this.put("THEMATIC_SURFACE__BUILDING_INSTALLATION_ID", NUMBER_COLUMN_VALUE);
                this.put("THEMATIC_SURFACE__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("THEMATIC_SURFACE__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("THEMATIC_SURFACE__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__CENTROID_WGS84", STRING_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__CENTROID_WGS84_LAT", NUMBER_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__CENTROID_WGS84_LON", NUMBER_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__BBOX_WGS84_LAT_MIN", NUMBER_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__BBOX_WGS84_LAT_MAX", NUMBER_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__BBOX_WGS84_LON_MIN", NUMBER_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__BBOX_WGS84_LON_MAX", NUMBER_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__BBOX_WGS84_HEIGHT_MIN", NUMBER_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__BBOX_WGS84_HEIGHT_MAX", NUMBER_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__BBOX_WGS84_LAT_LON", STRING_COLUMN_VALUE);
                this.put("SPECIAL_KEYWORDS__BBOX_WGS84_LON_LAT", STRING_COLUMN_VALUE);
                this.put("OPENING_TO_THEM_SURFACE__OPENING_ID", NUMBER_COLUMN_VALUE);
                this.put("OPENING_TO_THEM_SURFACE__THEMATIC_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__ID", NUMBER_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__CLASS", STRING_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__FUNCTION", STRING_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__USAGE", STRING_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__SURFACE_MATERIAL", STRING_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__SURFACE_MATERIAL_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TRAFFIC_AREA__TRANSPORTATION_COMPLEX_ID", NUMBER_COLUMN_VALUE);
                this.put("LAND_USE__ID", NUMBER_COLUMN_VALUE);
                this.put("LAND_USE__CLASS", STRING_COLUMN_VALUE);
                this.put("LAND_USE__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("LAND_USE__FUNCTION", STRING_COLUMN_VALUE);
                this.put("LAND_USE__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("LAND_USE__USAGE", STRING_COLUMN_VALUE);
                this.put("LAND_USE__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("LAND_USE__LOD0_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("LAND_USE__LOD1_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("LAND_USE__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("LAND_USE__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("LAND_USE__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT__ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("CITYOBJECT__GMLID", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__NAME", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__NAME_CODESPACE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__DESCRIPTION", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__ENVELOPE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__CREATION_DATE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__TERMINATION_DATE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__RELATIVE_TO_TERRAIN", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__RELATIVE_TO_WATER", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__LAST_MODIFICATION_DATE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__UPDATING_PERSON", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__REASON_FOR_UPDATE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__LINEAGE", STRING_COLUMN_VALUE);
                this.put("CITYOBJECT__XML_SOURCE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_THEMATIC_SURFACE__ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_THEMATIC_SURFACE__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_THEMATIC_SURFACE__TUNNEL_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_THEMATIC_SURFACE__TUNNEL_HOLLOW_SPACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_THEMATIC_SURFACE__TUNNEL_INSTALLATION_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_THEMATIC_SURFACE__LOD2_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_THEMATIC_SURFACE__LOD3_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_THEMATIC_SURFACE__LOD4_MULTI_SURFACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__CLASS", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__FUNCTION", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__USAGE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__TUNNEL_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__TUNNEL_HOLLOW_SPACE_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD2_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD3_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD2_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD3_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD4_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD2_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD2_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD2_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("TUNNEL_INSTALLATION__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__OBJECTCLASS_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__CLASS", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__CLASS_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__FUNCTION", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__FUNCTION_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__USAGE", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__USAGE_CODESPACE", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__BUILDING_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__ROOM_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD2_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD3_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD4_BREP_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD2_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD3_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD4_OTHER_GEOM", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD2_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD3_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD4_IMPLICIT_REP_ID", NUMBER_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD2_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD3_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD4_IMPLICIT_REF_POINT", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD2_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD3_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("BUILDING_INSTALLATION__LOD4_IMPLICIT_TRANSFORMATION", STRING_COLUMN_VALUE);
                this.put("APPEAR_TO_SURFACE_DATA__SURFACE_DATA_ID", NUMBER_COLUMN_VALUE);
                this.put("APPEAR_TO_SURFACE_DATA__APPEARANCE_ID", NUMBER_COLUMN_VALUE);
            }
        };
    }
}

