/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class ClipboardHandler
implements ClipboardOwner {
    ClipboardHandler() {
    }

    public boolean containsBBX() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        return clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
    }

    public void copy(double[] dArray) {
        if (dArray == null || dArray.length != 4) {
            return;
        }
        String string = "BBOX=" + Double.toString(dArray[0]) + "," + Double.toString(dArray[1]) + "," + Double.toString(dArray[2]) + "," + Double.toString(dArray[3]);
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public void copy(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public double[] paste() {
        String string = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            try {
                Transferable transferable = clipboard.getContents(null);
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                string = string.lastIndexOf(61) > -1 ? string.substring(string.lastIndexOf(61) + 1, string.length()).trim() : string.trim();
                String[] stringArray = string.split(",");
                if (stringArray.length != 4) {
                    return null;
                }
                double[] dArray = new double[]{Double.parseDouble(stringArray[0].trim()), Double.parseDouble(stringArray[1].trim()), Double.parseDouble(stringArray[2].trim()), Double.parseDouble(stringArray[3].trim())};
                return dArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

