/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen;

import java.util.Locale;
import java.util.ResourceBundle;
import org.citydb.api.controller.ApplicationStarter;
import org.citydb.api.plugin.Plugin;
import org.citydb.api.plugin.extension.config.ConfigExtension;
import org.citydb.api.plugin.extension.config.PluginConfigEvent;
import org.citydb.api.plugin.extension.view.View;
import org.citydb.api.plugin.extension.view.ViewExtension;
import org.citydb.plugins.spreadsheet_gen.config.ConfigImpl;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.CloudServiceRegistery;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.GoogleSpreadSheetService;
import org.citydb.plugins.spreadsheet_gen.gui.view.SPSHGView;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class spsheet_gen
implements Plugin,
ViewExtension,
ConfigExtension<ConfigImpl> {
    private ConfigImpl config;
    private Locale currentLocale;
    private SPSHGView view;

    public static void main(String[] stringArray) {
        ApplicationStarter applicationStarter = new ApplicationStarter();
        applicationStarter.run(stringArray, new Plugin[]{new spsheet_gen()});
    }

    public View getView() {
        return this.view;
    }

    public void init(Locale locale) {
        Util.I18N = ResourceBundle.getBundle("org.citydb.plugins.spreadsheet_gen.gui.locale", locale);
        this.initCloudServices();
        this.view = new SPSHGView(this);
        this.loadSettings();
        this.switchLocale(locale);
    }

    private void initCloudServices() {
        GoogleSpreadSheetService googleSpreadSheetService = new GoogleSpreadSheetService();
        CloudServiceRegistery.getInstance().registerService(googleSpreadSheetService, googleSpreadSheetService.getServiceName());
    }

    public void shutdown() {
        this.saveSettings();
    }

    public void switchLocale(Locale locale) {
        if (locale.equals(this.currentLocale)) {
            return;
        }
        Util.I18N = ResourceBundle.getBundle("org.citydb.plugins.spreadsheet_gen.gui.locale", locale);
        this.currentLocale = locale;
        this.view.switchLocale();
    }

    public void configLoaded(ConfigImpl configImpl) {
        boolean bl = this.config != null;
        this.setConfig(configImpl);
        if (bl) {
            this.loadSettings();
        }
    }

    public ConfigImpl getConfig() {
        return this.config;
    }

    public void setConfig(ConfigImpl configImpl) {
        this.config = configImpl;
    }

    public void handleEvent(PluginConfigEvent pluginConfigEvent) {
        switch (pluginConfigEvent) {
            case RESET_DEFAULT_CONFIG: {
                this.config = new ConfigImpl();
                this.loadSettings();
                break;
            }
            case PRE_SAVE_CONFIG: {
                this.saveSettings();
            }
        }
    }

    public void loadSettings() {
        this.view.loadSettings();
    }

    public void saveSettings() {
        this.view.saveSettings();
    }
}

