/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.gui.view.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.table.AbstractTableModel;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.CSVColumns;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class TableDataModel
extends AbstractTableModel {
    private String[] columnNames = null;
    private ArrayList<CSVColumns> rows = new ArrayList();

    public TableDataModel() {
        this.updateColumnsTitle();
    }

    public void updateColumnsTitle() {
        this.columnNames = new String[3];
        this.columnNames[0] = Util.I18N.getString("spshg.csvcolumns.manual.header.title");
        this.columnNames[1] = Util.I18N.getString("spshg.csvcolumns.manual.header.content");
        this.columnNames[2] = Util.I18N.getString("spshg.csvcolumns.manual.header.comment");
        this.fireTableStructureChanged();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.rows.get(n).getValue(n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.rows.get(n).setValue(n2, object);
    }

    public void addNewRow(CSVColumns cSVColumns) {
        cSVColumns.rownum = this.rows.size();
        this.rows.add(cSVColumns);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void editRow(CSVColumns cSVColumns) {
        this.rows.set(cSVColumns.rownum, cSVColumns);
        this.fireTableRowsUpdated(cSVColumns.rownum, cSVColumns.rownum);
    }

    public void removeRow(int[] nArray) {
        if (nArray == null || nArray.length < 0) {
            return;
        }
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] >= this.rows.size()) continue;
            this.rows.remove(nArray[i]);
            for (int j = nArray[i]; j < this.rows.size(); ++j) {
                this.rows.get((int)j).rownum = j;
            }
            this.fireTableRowsDeleted(nArray[i], nArray[i]);
        }
    }

    public void move(int n, boolean bl) {
        if (n < 0 || n >= this.rows.size()) {
            return;
        }
        if (bl && n == 0) {
            return;
        }
        if (!bl && n == this.rows.size() - 1) {
            return;
        }
        int n2 = this.rows.get((int)n).rownum;
        this.rows.get((int)n).rownum = this.rows.get((int)(bl ? n - 1 : n + 1)).rownum;
        this.rows.get((int)(bl ? n - 1 : n + 1)).rownum = n2;
        Collections.sort(this.rows);
        this.fireTableDataChanged();
    }

    public CSVColumns getCSVColumn(int n) {
        if (n < 0 || n >= this.rows.size()) {
            return null;
        }
        return this.rows.get(n);
    }

    public boolean isSeparatorPhraseSuitable(String string) {
        return false;
    }

    public ArrayList<CSVColumns> getRows() {
        return this.rows;
    }

    public void reset() {
        int n = this.rows.size();
        this.rows = new ArrayList();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
    }
}

