/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.gui.view.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.citydb.api.event.Event;
import org.citydb.api.event.EventDispatcher;
import org.citydb.api.event.EventHandler;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.plugins.spreadsheet_gen.events.EventType;
import org.citydb.plugins.spreadsheet_gen.events.StatusDialogMessage;
import org.citydb.plugins.spreadsheet_gen.events.StatusDialogTitle;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class StatusDialog
extends JDialog
implements EventHandler {
    final EventDispatcher eventDispatcher = ObjectRegistry.getInstance().getEventDispatcher();
    private JLabel titleLabel;
    private JLabel messageLabel;
    private JProgressBar progressBar;
    private JLabel detailsLabel;
    private JPanel main;
    private JPanel row;
    private JButton button;
    private volatile boolean acceptStatusUpdate = true;

    public StatusDialog(JFrame jFrame, String string, String string2, String string3, String string4, boolean bl) {
        super(jFrame, string, true);
        this.eventDispatcher.addEventHandler((Enum)EventType.STATUS_DIALOG_MESSAGE, (EventHandler)this);
        this.eventDispatcher.addEventHandler((Enum)EventType.STATUS_DIALOG_TITLE, (EventHandler)this);
        this.eventDispatcher.addEventHandler((Enum)EventType.INTERRUPT, (EventHandler)this);
        this.initGUI(string, string2, string3, string4, bl);
    }

    private void initGUI(String string, String string2, String string3, String string4, boolean bl) {
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        String[] stringArray = null;
        if (string4 != null) {
            stringArray = string4.split("<br\\s*/*>");
        }
        this.setDefaultCloseOperation(0);
        this.titleLabel = new JLabel(string2);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.messageLabel = new JLabel(string3);
        this.button = new JButton(Util.I18N.getString("common.button.cancel"));
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.main = new JPanel();
        this.add((Component)this.main, Util.setConstraints(0, 0, 1.0, 0.0, 1, 5, 5, 5, 5));
        this.main.setLayout(new GridBagLayout());
        this.main.add((Component)this.titleLabel, Util.setConstraints(0, 0, 0.0, 0.5, 2, 5, 5, 5, 5));
        this.main.add((Component)this.messageLabel, Util.setConstraints(0, 1, 0.0, 0.5, 2, 5, 5, 0, 5));
        this.main.add((Component)this.progressBar, Util.setConstraints(0, 2, 1.0, 0.0, 2, 0, 5, 5, 5));
        if (stringArray != null) {
            this.detailsLabel = new JLabel("Details");
            this.main.add((Component)this.detailsLabel, Util.setConstraints(0, 3, 1.0, 0.0, 2, 5, 5, 0, 5));
            this.row = new JPanel();
            this.row.setBackground(new Color(255, 255, 255));
            this.row.setBorder(BorderFactory.createEtchedBorder());
            this.main.add((Component)this.row, Util.setConstraints(0, 4, 1.0, 0.0, 1, 0, 5, 5, 5));
            this.row.setLayout(new GridBagLayout());
            for (int i = 0; i < stringArray.length; ++i) {
                JLabel jLabel = new JLabel(stringArray[i]);
                jLabel.setBackground(this.row.getBackground());
                this.row.add((Component)jLabel, Util.setConstraints(0, i, 1.0, 0.0, 2, i == 0 ? 5 : 2, 5, i == stringArray.length - 1 ? 5 : 0, 5));
            }
        }
        if (bl) {
            this.add((Component)this.button, Util.setConstraints(0, 1, 0.0, 0.0, 0, 5, 5, 5, 5));
        }
        this.pack();
        this.progressBar.setIndeterminate(true);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                StatusDialog.this.eventDispatcher.removeEventHandler((EventHandler)StatusDialog.this);
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
    }

    public JLabel getStatusTitleLabel() {
        return this.titleLabel;
    }

    public JLabel getStatusMessageLabel() {
        return this.messageLabel;
    }

    public JButton getButton() {
        return this.button;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void handleEvent(Event event) throws Exception {
        if (event.getEventType() == EventType.INTERRUPT) {
            this.acceptStatusUpdate = false;
            this.messageLabel.setText(Util.I18N.getString("common.dialog.msg.abort"));
            this.progressBar.setIndeterminate(true);
        } else if (event.getEventType() == EventType.STATUS_DIALOG_MESSAGE && this.acceptStatusUpdate) {
            this.messageLabel.setText(((StatusDialogMessage)event).getMessage());
        } else if (event.getEventType() == EventType.STATUS_DIALOG_TITLE && this.acceptStatusUpdate) {
            this.titleLabel.setText(((StatusDialogTitle)event).getTitle());
        }
    }
}

