/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.gui.view.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.citydb.api.controller.ViewController;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.modules.common.balloon.BalloonTemplateHandlerImpl;
import org.citydb.plugins.spreadsheet_gen.database.Translator;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.CSVColumns;
import org.citydb.plugins.spreadsheet_gen.gui.view.SPSHGPanel;
import org.citydb.plugins.spreadsheet_gen.gui.view.components.DBColumn;
import org.citydb.plugins.spreadsheet_gen.gui.view.components.DBTable;
import org.citydb.plugins.spreadsheet_gen.gui.view.components.PopupActionListener;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class NewCSVColumnDialog
extends JDialog {
    protected static final int BORDER_THICKNESS = 5;
    protected static final int MAX_TEXTFIELD_HEIGHT = 20;
    protected static final int MAX_LABEL_WIDTH = 60;
    private static final int PREFERRED_WIDTH = 50;
    private static final int PREFERRED_HEIGHT = 50;
    public static final String EOL = "[EOL]";
    private final ViewController viewController;
    private JTextField titleText;
    private JTextArea commentText;
    private JTextPane content;
    private JButton addFieldButton;
    private JButton insertButton;
    private JButton cancelButton;
    private JButton functionButton;
    private JButton eolButton;
    private JTree tree;
    private CSVColumns newCSVColumn;
    private StyledDocument document;
    private static Style labelStyle;
    private static Style defaultStyle;
    private static Style EOLStyle;
    private int caretPositionDot;
    private int caretPositionMark;
    private boolean isEditMode = false;
    private JPopupMenu popup;
    private Set<String> aggregations;
    private HashMap<String, Set<String>> _3dcitydbcontent;
    final SPSHGPanel panel;
    final Highlighter hilit;
    final Highlighter.HighlightPainter painter;
    private Color highlightColor = Color.lightGray;
    private String oldTreeSelectedPaths = null;

    public NewCSVColumnDialog(JFrame jFrame, SPSHGPanel sPSHGPanel) {
        super(jFrame, Util.I18N.getString("spshg.dialog.addnewcolumn.header"), true);
        this.hilit = new DefaultHighlighter();
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(this.highlightColor);
        this.viewController = ObjectRegistry.getInstance().getViewController();
        this.panel = sPSHGPanel;
        this.newCSVColumn = new CSVColumns();
        this.isEditMode = false;
        this.init();
    }

    public NewCSVColumnDialog(JFrame jFrame, SPSHGPanel sPSHGPanel, CSVColumns cSVColumns) {
        super(jFrame, Util.I18N.getString("spshg.dialog.addnewcolumn.header"), true);
        this.hilit = new DefaultHighlighter();
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(this.highlightColor);
        this.viewController = ObjectRegistry.getInstance().getViewController();
        this.panel = sPSHGPanel;
        this.newCSVColumn = cSVColumns;
        this.isEditMode = true;
        this.init();
    }

    private void init() {
        BalloonTemplateHandlerImpl balloonTemplateHandlerImpl = new BalloonTemplateHandlerImpl("", null);
        this.aggregations = balloonTemplateHandlerImpl.getSupportedAggregationFunctions();
        this._3dcitydbcontent = balloonTemplateHandlerImpl.getSupportedTablesAndColumns();
        this.setSize(new Dimension(50, 50));
        Box box = Box.createVerticalBox();
        JLabel jLabel = new JLabel(Util.I18N.getString("spshg.dialog.addnewcolumn.title"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        this.titleText = new JTextField(this.newCSVColumn.title);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        Box box2 = Box.createVerticalBox();
        JLabel jLabel2 = new JLabel(Util.I18N.getString("spshg.dialog.addnewcolumn.content"));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jLabel2, "West");
        this.document = this.newCSVColumn.document;
        NewCSVColumnDialog.getDefaultStyle();
        NewCSVColumnDialog.getLabelStyle();
        NewCSVColumnDialog.getEOLStyle();
        this.content = new JTextPane(this.document);
        this.content.setSize(21, 300);
        this.content.setPreferredSize(new Dimension(150, 250));
        this.content.setBorder(BorderFactory.createLineBorder(Color.black));
        this.content.setEditable(true);
        this.caretPositionMark = 0;
        this.caretPositionDot = 0;
        this.content.setCaretPosition(this.caretPositionDot);
        this.content.setFont(new Font("Tahoma", 0, 12));
        this.content.setForeground(Color.blue);
        this.content.getCaret().setSelectionVisible(true);
        this.content.setHighlighter(this.hilit);
        JScrollPane jScrollPane = new JScrollPane(this.content);
        JLabel jLabel3 = new JLabel(Util.I18N.getString("spshg.dialog.addnewcolumn.avilablefromdb"));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jLabel3, "West");
        this.tree = this.generateTree();
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane jScrollPane2 = new JScrollPane(this.tree);
        jScrollPane.setPreferredSize(jScrollPane2.getPreferredSize());
        jScrollPane2.setPreferredSize(jScrollPane.getPreferredSize());
        jScrollPane.setMinimumSize(jScrollPane2.getPreferredSize());
        jScrollPane2.setMinimumSize(jScrollPane.getPreferredSize());
        box2.add(jPanel3);
        box2.add(Box.createRigidArea(new Dimension(0, 5)));
        box2.add(jScrollPane);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 1));
        this.addFieldButton = new JButton(Util.I18N.getString("spshg.dialog.addnewcolumn.addbutton"));
        this.functionButton = new JButton(Util.I18N.getString("spshg.dialog.addnewcolumn.funcaddbutton"));
        this.eolButton = new JButton(Util.I18N.getString("spshg.dialog.addnewcolumn.eolbutton"));
        this.eolButton.setToolTipText(Util.I18N.getString("spshg.dialog.addnewcolumn.tooltip.eol"));
        this.functionButton.setToolTipText(Util.I18N.getString("spshg.dialog.addnewcolumn.tooltip.funcaddbutton"));
        this.addFieldButton.setToolTipText(Util.I18N.getString("spshg.dialog.addnewcolumn.tooltip.addbutton"));
        jPanel5.add(this.addFieldButton);
        jPanel5.add(this.functionButton);
        jPanel5.add(this.eolButton);
        Box box3 = Box.createVerticalBox();
        box3.add(jPanel4);
        box3.add(Box.createRigidArea(new Dimension(0, 5)));
        box3.add(jScrollPane2);
        GridBagConstraints gridBagConstraints = Util.setConstraints(0, 0, 0.0, 0.0, 0, 5, 5, 5, 5);
        gridBagConstraints.gridwidth = 3;
        jPanel2.add((Component)box3, gridBagConstraints);
        jPanel2.add((Component)jPanel5, Util.setConstraints(3, 0, 0.0, 0.0, 0, 5, 5, 5, 5));
        gridBagConstraints = Util.setConstraints(4, 0, 0.0, 0.0, 0, 5, 5, 5, 5);
        gridBagConstraints.gridwidth = 3;
        jPanel2.add((Component)box2, gridBagConstraints);
        JLabel jLabel4 = new JLabel(Util.I18N.getString("spshg.dialog.addnewcolumn.comment"));
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jLabel4, "West");
        this.commentText = new JTextArea(3, 10);
        this.commentText.setLineWrap(true);
        this.commentText.setText(this.newCSVColumn.comment);
        JScrollPane jScrollPane3 = new JScrollPane(this.commentText);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        Box box4 = Box.createHorizontalBox();
        jPanel7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.insertButton = this.isEditMode ? new JButton(Util.I18N.getString("spshg.dialog.addnewcolumn.edit")) : new JButton(Util.I18N.getString("spshg.dialog.addnewcolumn.insert"));
        this.cancelButton = new JButton(Util.I18N.getString("common.button.cancel"));
        box4.add(this.insertButton);
        box4.add(Box.createRigidArea(new Dimension(5, 0)));
        box4.add(this.cancelButton);
        jPanel7.add((Component)box4, "East");
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(jPanel);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(this.titleText);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(jPanel2);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(jPanel6);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(jScrollPane3);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(jPanel7);
        this.setLayout(new BorderLayout());
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)box, "North");
        this.makeFunctionPopup();
        this.viewController.getComponentFactory().createPopupMenuDecorator().decorate(new JTextComponent[]{this.titleText, this.content, this.commentText});
        this.addListeners();
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        this.setPreferredSize(this.getPreferredSize());
    }

    private void addListeners() {
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    NewCSVColumnDialog.this.addFieldFromDB(null);
                } else if (NewCSVColumnDialog.this.oldTreeSelectedPaths != null && NewCSVColumnDialog.this.tree.getSelectionPath() != null && NewCSVColumnDialog.this.tree.getSelectionPath().toString().trim().equalsIgnoreCase(NewCSVColumnDialog.this.oldTreeSelectedPaths)) {
                    NewCSVColumnDialog.this.tree.clearSelection();
                }
                if (NewCSVColumnDialog.this.tree.getSelectionPath() != null) {
                    NewCSVColumnDialog.this.oldTreeSelectedPaths = NewCSVColumnDialog.this.tree.getSelectionPath().toString().trim();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }
        });
        this.content.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                NewCSVColumnDialog.this.caretPositionDot = caretEvent.getDot();
                NewCSVColumnDialog.this.caretPositionMark = caretEvent.getMark();
            }
        });
        this.content.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                NewCSVColumnDialog.this.content.setCharacterAttributes(defaultStyle, true);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    NewCSVColumnDialog.this.insertEOL();
                    keyEvent.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                }
            }
        });
        this.content.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    NewCSVColumnDialog.this.hilit.addHighlight(NewCSVColumnDialog.this.content.getSelectionStart(), NewCSVColumnDialog.this.content.getSelectionEnd(), NewCSVColumnDialog.this.painter);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                NewCSVColumnDialog.this.hilit.removeAllHighlights();
            }
        });
        this.addFieldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewCSVColumnDialog.this.addFieldFromDB(null);
            }
        });
        this.functionButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                NewCSVColumnDialog.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
        this.eolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewCSVColumnDialog.this.insertEOL();
            }
        });
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = NewCSVColumnDialog.this.titleText.getText();
                String string2 = NewCSVColumnDialog.this.content.getText();
                if (string != null && string.trim().length() == 0) {
                    string = Translator.getInstance().getProperHeader(string2);
                }
                if (string != null && string.trim().length() > 0 && (string.startsWith(";") || string.startsWith("\\"))) {
                    NewCSVColumnDialog.this.errorMessage("Error", Util.I18N.getString("spshg.dialog.addnewcolumn.error.title.start"));
                    return;
                }
                if (string != null && string.trim().length() == 0) {
                    NewCSVColumnDialog.this.errorMessage("Error", Util.I18N.getString("spshg.dialog.addnewcolumn.error.title"));
                    return;
                }
                if (string2 != null && string2.trim().length() == 0) {
                    NewCSVColumnDialog.this.errorMessage("Error", Util.I18N.getString("spshg.dialog.addnewcolumn.error.content"));
                    return;
                }
                if (string2.startsWith(":")) {
                    NewCSVColumnDialog.this.errorMessage("Error", Util.I18N.getString("spshg.dialog.addnewcolumn.error.content.start"));
                    return;
                }
                NewCSVColumnDialog.this.newCSVColumn.setValues(string, string2, NewCSVColumnDialog.this.commentText.getText(), NewCSVColumnDialog.this.document);
                if (NewCSVColumnDialog.this.isEditMode) {
                    NewCSVColumnDialog.this.panel.editColumnInManualCSV(NewCSVColumnDialog.this.newCSVColumn);
                } else {
                    NewCSVColumnDialog.this.panel.addNewColumnInManualCSV(NewCSVColumnDialog.this.newCSVColumn);
                }
                NewCSVColumnDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewCSVColumnDialog.this.setVisible(false);
            }
        });
    }

    private void makeFunctionPopup() {
        this.popup = new JPopupMenu();
        for (String string : this.aggregations) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new PopupActionListener(this, "[" + string + "]"));
            this.popup.add(jMenuItem);
        }
    }

    public void insertInContent(String string) {
        try {
            if (this.caretPositionDot != this.caretPositionMark) {
                this.document.remove(Math.min(this.caretPositionDot, this.caretPositionMark), Math.abs(this.caretPositionMark - this.caretPositionDot));
            }
            this.document.insertString(this.caretPositionDot, string, labelStyle);
            this.content.setCharacterAttributes(defaultStyle, true);
            this.content.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void insertEOL() {
        try {
            if (this.caretPositionDot != this.caretPositionMark) {
                this.document.remove(Math.min(this.caretPositionDot, this.caretPositionMark), Math.abs(this.caretPositionMark - this.caretPositionDot));
            }
            this.document.insertString(this.caretPositionDot, EOL, EOLStyle);
            this.content.setCharacterAttributes(defaultStyle, true);
            this.content.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addFieldFromDB(String string) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length < 1) {
            this.replaceAggregationFunction(string);
            return;
        }
        String string2 = treePathArray[0].toString().trim();
        if (string2.matches(".*,.*,.*")) {
            String string3 = string2.substring(string2.indexOf(44) + 1, string2.length() - 1).trim();
            string3 = string3.replaceAll(", ", "/");
            String string4 = string != null ? string3.replaceAll("/", "/" + string) : string3;
            this.insertInContent(string4);
        }
    }

    private void replaceAggregationFunction(String string) {
        try {
            if (this.caretPositionDot == this.caretPositionMark) {
                return;
            }
            if (string == null || string.length() < 1) {
                return;
            }
            int n = Math.min(this.content.getSelectionStart(), this.content.getSelectionEnd());
            int n2 = Math.max(this.content.getSelectionStart(), this.content.getSelectionEnd()) - n;
            String string2 = "";
            try {
                string2 = this.document.getText(n, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            int n3 = -1;
            boolean bl = false;
            for (String string3 : this.aggregations) {
                if (string.contains(string3)) continue;
                String string4 = "[" + string3 + "]";
                while ((n3 = string2.indexOf(string4)) >= 0) {
                    this.document.remove(n + n3, string4.length());
                    this.document.insertString(n + n3, string, labelStyle);
                    string2 = string2.replaceFirst("\\Q" + string4 + "\\E", string);
                    bl = true;
                }
            }
            if (!bl) {
                n3 = -1;
                while ((n3 = string2.indexOf("/", n3 + 1)) >= 0) {
                    if (string2.regionMatches(n3, "/[", 0, 2)) continue;
                    this.document.insertString(n + n3 + 1, string, labelStyle);
                    string2 = this.document.getText(n, n2 += string.length());
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private JTree generateTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("3D City DB");
        this.createNodes(defaultMutableTreeNode);
        return new JTree(defaultMutableTreeNode);
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        if (this._3dcitydbcontent == null) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>(this._3dcitydbcontent.keySet());
        for (String string : treeSet) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DBTable(string));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            Set<String> set = this._3dcitydbcontent.get(string);
            for (String string2 : set) {
                defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DBColumn(string2, string));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
        }
    }

    private void errorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string2, string, 0);
    }

    public static Style getDefaultStyle() {
        if (defaultStyle == null) {
            StyleContext styleContext = new StyleContext();
            defaultStyle = styleContext.getStyle("default");
            StyleConstants.setAlignment(defaultStyle, 0);
            StyleConstants.setSpaceAbove(defaultStyle, 4.0f);
            StyleConstants.setSpaceBelow(defaultStyle, 4.0f);
            StyleConstants.setFontFamily(defaultStyle, "Tahoma");
            StyleConstants.setFontSize(defaultStyle, 12);
            StyleConstants.setForeground(defaultStyle, Color.blue);
        }
        return defaultStyle;
    }

    public static Style getLabelStyle() {
        if (labelStyle != null) {
            return labelStyle;
        }
        if (defaultStyle == null) {
            NewCSVColumnDialog.getDefaultStyle();
        }
        StyleContext styleContext = new StyleContext();
        labelStyle = styleContext.addStyle("Label", defaultStyle);
        StyleConstants.setForeground(labelStyle, Color.red);
        StyleConstants.setBackground(labelStyle, Color.yellow);
        return labelStyle;
    }

    public static Style getEOLStyle() {
        if (EOLStyle != null) {
            return EOLStyle;
        }
        if (defaultStyle == null) {
            NewCSVColumnDialog.getDefaultStyle();
        }
        StyleContext styleContext = new StyleContext();
        EOLStyle = styleContext.addStyle("EOL", defaultStyle);
        StyleConstants.setForeground(EOLStyle, Color.black);
        StyleConstants.setBackground(EOLStyle, Color.lightGray);
        return EOLStyle;
    }
}

