/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.gui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.citydb.api.controller.DatabaseController;
import org.citydb.api.controller.LogController;
import org.citydb.api.controller.ViewController;
import org.citydb.api.database.DatabaseConfigurationException;
import org.citydb.api.database.DatabaseVersionException;
import org.citydb.api.event.Event;
import org.citydb.api.event.EventDispatcher;
import org.citydb.api.event.EventHandler;
import org.citydb.api.event.global.DatabaseConnectionStateEvent;
import org.citydb.api.event.global.GlobalEvents;
import org.citydb.api.gui.BoundingBoxPanel;
import org.citydb.api.log.LogLevel;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.database.DatabaseConnectionPool;
import org.citydb.plugins.spreadsheet_gen.config.ConfigImpl;
import org.citydb.plugins.spreadsheet_gen.controller.SpreadsheetExporter;
import org.citydb.plugins.spreadsheet_gen.controller.TemplateWriter;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.AuthenticationException;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.CaptchaRequiredException;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.CloudServiceRegistery;
import org.citydb.plugins.spreadsheet_gen.database.Translator;
import org.citydb.plugins.spreadsheet_gen.events.EventType;
import org.citydb.plugins.spreadsheet_gen.events.InterruptEvent;
import org.citydb.plugins.spreadsheet_gen.events.UploadEvent;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.CSVColumns;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.SelectedCityObjects;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.SeparatorPhrase;
import org.citydb.plugins.spreadsheet_gen.gui.view.CustonButtonMouseListener;
import org.citydb.plugins.spreadsheet_gen.gui.view.PopupCityObjectActionListener;
import org.citydb.plugins.spreadsheet_gen.gui.view.PopupPhraseActionListener;
import org.citydb.plugins.spreadsheet_gen.gui.view.StayOpenCheckBoxMenuItemUI;
import org.citydb.plugins.spreadsheet_gen.gui.view.components.NewCSVColumnDialog;
import org.citydb.plugins.spreadsheet_gen.gui.view.components.StatusDialog;
import org.citydb.plugins.spreadsheet_gen.gui.view.components.TableDataModel;
import org.citydb.plugins.spreadsheet_gen.spsheet_gen;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class SPSHGPanel
extends JPanel
implements EventHandler {
    protected static final int BORDER_THICKNESS = 5;
    protected static final int MAX_TEXTFIELD_HEIGHT = 20;
    protected static final int MAX_LABEL_WIDTH = 60;
    private static final int PREFERRED_WIDTH = 560;
    private static final int PREFERRED_HEIGHT = 780;
    private final LogController logController;
    private final ViewController viewController;
    private final DatabaseController dbController;
    private final DatabaseConnectionPool dbPool;
    private final spsheet_gen plugin;
    private final ReentrantLock mainLock = new ReentrantLock();
    private Box jPanelInput;
    private JPanel csvColumnsPanel;
    private JLabel templateLabel = new JLabel("");
    private JPanel browsePanel;
    private JTextField browseText = new JTextField("");
    private JButton browseButton = new JButton("");
    private JButton editTemplateButton = new JButton("");
    private JButton manuallyTemplateButton = new JButton("");
    private JPanel contentSource;
    private JLabel gfPrefLabel = new JLabel("");
    private JTextArea generateDataFor = new JTextArea(2, 10);
    private JLabel editGenerateData = new JLabel();
    private JPopupMenu cityObjectPopup = new JPopupMenu();
    private JPanel versioningPanel;
    private JLabel workspaceLabel = new JLabel();
    private JTextField workspaceText = new JTextField("LIVE");
    private JLabel timestampLabel = new JLabel();
    private JTextField timestampText = new JTextField("");
    private BoundingBoxPanel bbXPanel;
    private JPanel outputPanel;
    private ButtonGroup outputButtonGroup = new ButtonGroup();
    private JRadioButton csvRadioButton = new JRadioButton("");
    private JPanel csvPanel;
    private JLabel browseOutputLabel = new JLabel("");
    private JTextField browseOutputText = new JTextField("");
    private JButton browseOutputButton = new JButton("");
    private JLabel separatorLabel = new JLabel("");
    private JTextField separatorText = new JTextField("");
    private JPopupMenu separatorListPopup = new JPopupMenu();
    JLabel predefiendLabel = new JLabel("");
    private JRadioButton xlsxRadioButton = new JRadioButton("");
    private JPanel xlsxPanel;
    private JTextField xlsxBrowseOutputText = new JTextField("");
    private JButton xlsxBrowseOutputButton = new JButton("");
    private JRadioButton onlineRadioButton = new JRadioButton("");
    private JPanel onlinePanel;
    private JLabel serviceType = new JLabel("");
    private JComboBox serviceComboBox = new JComboBox();
    private JLabel emailLabel = new JLabel("");
    private JTextField emailText = new JTextField("", 15);
    private JLabel passLabel = new JLabel("");
    private JPasswordField passText = new JPasswordField("", 15);
    private Box captchaBox = Box.createVerticalBox();
    private JLabel captchaImage = new JLabel("");
    private JTextField captchaText = new JTextField("", 15);
    private String captchaToken = null;
    private JLabel spreadsheetNameLabel = new JLabel("");
    private JTextField spreadsheetNameText = new JTextField("", 15);
    private JLabel linkToSpSheetButton = new JLabel();
    private JLabel privacyButton = new JLabel();
    private boolean successUpload = false;
    private String uploadResultURL = "";
    private JButton exportButton = new JButton("");
    private ConfigImpl config;
    private JPanel manualPanel;
    private JPanel rightHandMenu;
    private JScrollPane scrollPane;
    private JTable table;
    private TableDataModel tableDataModel = new TableDataModel();
    private JButton upButton = new JButton("");
    private JButton downButton = new JButton("");
    private JButton editButton = new JButton("");
    private JButton addButton = new JButton("");
    private JButton removeButton = new JButton("");
    private JButton saveButton = new JButton("");
    private JLabel saveMessage = new JLabel("");
    private String previousvisitBySaveTemplate = "";
    final JFileChooser fileChooserTemplate = new JFileChooser();
    final JFileChooser fileChooserCSVOut = new JFileChooser();
    final JFileChooser fileChooserXLSXOut = new JFileChooser();

    SPSHGPanel(spsheet_gen spsheet_gen2) {
        this.plugin = spsheet_gen2;
        this.viewController = ObjectRegistry.getInstance().getViewController();
        this.logController = ObjectRegistry.getInstance().getLogController();
        this.dbController = ObjectRegistry.getInstance().getDatabaseController();
        this.dbPool = DatabaseConnectionPool.getInstance();
        ObjectRegistry.getInstance().getEventDispatcher().addEventHandler((Enum)EventType.UPLOAD_EVENT, (EventHandler)this);
        ObjectRegistry.getInstance().getEventDispatcher().addEventHandler((Enum)GlobalEvents.DATABASE_CONNECTION_STATE, (EventHandler)this);
        this.config = spsheet_gen2.getConfig();
        this.initGui();
        this.addListeners();
        this.clearGui();
    }

    private void initGui() {
        this.jPanelInput = Box.createVerticalBox();
        this.csvColumnsPanel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.add(this.templateLabel);
        this.browsePanel = new JPanel();
        this.browsePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Util.setConstraints(0, 0, 1.0, 1.0, 2, 5, 30, 5, 5);
        gridBagConstraints.gridwidth = 3;
        this.browsePanel.add((Component)this.browseText, gridBagConstraints);
        this.browseText.setColumns(10);
        this.browsePanel.add((Component)this.browseButton, Util.setConstraints(3, 0, 0.0, 0.0, 0, 5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jPanel2.add((Component)jLabel, Util.setConstraints(0, 0, 1.0, 1.0, 1, 5, 30, 5, 5));
        gridBagConstraints = Util.setConstraints(1, 0, 1.0, 1.0, 0, 5, 5, 5, 0);
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.manuallyTemplateButton, gridBagConstraints);
        gridBagConstraints = Util.setConstraints(0, 1, 1.0, 1.0, 1, 5, 30, 5, 5);
        gridBagConstraints.gridwidth = 3;
        this.browsePanel.add((Component)jPanel2, gridBagConstraints);
        this.browsePanel.add((Component)this.editTemplateButton, Util.setConstraints(3, 1, 0.0, 0.0, 0, 5, 5, 5, 5));
        this.manualPanel = new JPanel();
        this.rightHandMenu = new JPanel();
        this.rightHandMenu.setLayout(new GridLayout(0, 1));
        this.table = new JTable(this.tableDataModel);
        this.table.setAutoResizeMode(3);
        this.table.setCellSelectionEnabled(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.modifyTableColumnsSize();
        this.scrollPane = new JScrollPane(this.table);
        this.rightHandMenu.add(this.addButton);
        this.rightHandMenu.add(this.removeButton);
        this.rightHandMenu.add(this.editButton);
        this.rightHandMenu.add(this.upButton);
        this.rightHandMenu.add(this.downButton);
        this.manualPanel.setLayout(new GridBagLayout());
        gridBagConstraints = Util.setConstraints(0, 0, 1.0, 1.0, 2, 5, 30, 5, 5);
        gridBagConstraints.gridwidth = 3;
        this.manualPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.manualPanel.add((Component)this.rightHandMenu, Util.setConstraints(3, 0, 0.0, 0.0, 0, 5, 5, 5, 5));
        gridBagConstraints = Util.setConstraints(0, 1, 1.0, 1.0, 2, 5, 30, 5, 5);
        gridBagConstraints.gridwidth = 3;
        this.manualPanel.add((Component)this.saveMessage, gridBagConstraints);
        this.manualPanel.add((Component)this.saveButton, Util.setConstraints(3, 1, 0.0, 0.0, 0, 5, 5, 5, 5));
        box.add(jPanel);
        box.add(this.browsePanel);
        box.add(this.manualPanel);
        this.manualPanel.setVisible(false);
        this.csvColumnsPanel.add((Component)box, "Center");
        this.contentSource = new JPanel(new BorderLayout());
        this.contentSource.setBorder(BorderFactory.createTitledBorder(""));
        Box box2 = Box.createVerticalBox();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 6, 5, 6));
        Box box3 = Box.createHorizontalBox();
        this.editGenerateData.setIcon(this.createImageIcon("img/edit.png", "edit"));
        box3.add(this.gfPrefLabel);
        box3.add(Box.createRigidArea(new Dimension(5, 0)));
        box3.add(this.editGenerateData);
        box3.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel3.add((Component)box3, "West");
        this.generateDataFor.setLineWrap(true);
        this.generateDataFor.setWrapStyleWord(true);
        this.generateDataFor.setEditable(false);
        this.generateDataFor.setFont(new Font("Arial", 0, 12));
        jPanel3.add((Component)new JScrollPane(this.generateDataFor), "Center");
        this.gfPrefLabel.setAlignmentY(0.0f);
        this.generateDataFor.setAlignmentY(0.0f);
        this.editGenerateData.setAlignmentY(0.0f);
        this.versioningPanel = new JPanel();
        this.versioningPanel.setLayout(new GridBagLayout());
        this.versioningPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.versioningPanel.add((Component)this.workspaceLabel, Util.setConstraints(0, 0, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.versioningPanel.add((Component)this.workspaceText, Util.setConstraints(1, 0, 0.5, 0.0, 2, 0, 5, 5, 5));
        this.versioningPanel.add((Component)this.timestampLabel, Util.setConstraints(2, 0, 0.0, 0.0, 2, 0, 10, 5, 5));
        this.versioningPanel.add((Component)this.timestampText, Util.setConstraints(3, 0, 0.5, 0.0, 2, 0, 5, 5, 5));
        this.bbXPanel = this.viewController.getComponentFactory().createBoundingBoxPanel();
        this.outputPanel = new JPanel();
        this.outputPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.outputPanel.setLayout(new BorderLayout());
        this.outputButtonGroup.add(this.csvRadioButton);
        this.outputButtonGroup.add(this.xlsxRadioButton);
        this.outputButtonGroup.add(this.onlineRadioButton);
        this.csvRadioButton.setIconTextGap(10);
        this.xlsxRadioButton.setIconTextGap(10);
        this.onlineRadioButton.setIconTextGap(10);
        this.csvRadioButton.setSelected(true);
        box2.add(jPanel3);
        box2.add(Box.createRigidArea(new Dimension(0, 5)));
        box2.add(this.versioningPanel);
        box2.add(Box.createRigidArea(new Dimension(0, 5)));
        box2.add((Component)this.bbXPanel);
        this.contentSource.add((Component)box2, "Center");
        JPanel jPanel4 = new JPanel();
        Box box4 = Box.createVerticalBox();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.csvRadioButton, "West");
        this.separatorText.setColumns(10);
        this.predefiendLabel.setIcon(this.createImageIcon("img/edit.png", "Use predefiend list"));
        this.csvPanel = new JPanel();
        this.csvPanel.setLayout(new GridBagLayout());
        gridBagConstraints = Util.setConstraints(0, 0, 1.0, 1.0, 2, 5, 30, 5, 5);
        gridBagConstraints.gridwidth = 3;
        this.csvPanel.add((Component)this.browseOutputText, gridBagConstraints);
        this.browseOutputText.setColumns(10);
        this.csvPanel.add((Component)this.browseOutputButton, Util.setConstraints(3, 0, 0.0, 0.0, 0, 5, 5, 5, 5));
        Box box5 = Box.createHorizontalBox();
        box5.add(this.separatorLabel);
        box5.add(Box.createRigidArea(new Dimension(5, 0)));
        box5.add(this.separatorText);
        box5.add(this.predefiendLabel);
        this.csvPanel.add((Component)box5, Util.setConstraints(0, 1, 0.0, 0.0, 2, 0, 30, 5, 5));
        JPanel jPanel5 = new JPanel();
        Box box6 = Box.createVerticalBox();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.xlsxRadioButton, "West");
        this.xlsxPanel = new JPanel();
        this.xlsxPanel.setLayout(new GridBagLayout());
        gridBagConstraints = Util.setConstraints(0, 0, 1.0, 1.0, 2, 5, 30, 5, 5);
        gridBagConstraints.gridwidth = 3;
        this.xlsxPanel.add((Component)this.xlsxBrowseOutputText, gridBagConstraints);
        this.xlsxBrowseOutputText.setColumns(10);
        this.xlsxPanel.add((Component)this.xlsxBrowseOutputButton, Util.setConstraints(3, 0, 0.0, 0.0, 0, 5, 5, 5, 5));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)this.onlineRadioButton, "West");
        this.onlinePanel = new JPanel();
        this.onlinePanel.setLayout(new GridBagLayout());
        Box box7 = Box.createHorizontalBox();
        this.privacyButton.addMouseListener(new CustonButtonMouseListener(this, 2, this.privacyButton, "img/privacy_16.png", "img/privacy_19.png"));
        this.linkToSpSheetButton.addMouseListener(new CustonButtonMouseListener(this, 1, this.linkToSpSheetButton, "img/copylink_16.png", "img/copylink_19.png"));
        box7.add(this.linkToSpSheetButton);
        box7.add(Box.createRigidArea(new Dimension(5, 20)));
        box7.add(this.privacyButton);
        this.serviceComboBox = new JComboBox<Object>(CloudServiceRegistery.getInstance().getListofServices().toArray());
        this.serviceComboBox.setSelectedIndex(0);
        this.captchaBox.add(this.captchaImage);
        this.captchaBox.add(this.captchaText);
        this.onlinePanel.add((Component)this.serviceType, Util.setConstraints(0, 0, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.onlinePanel.add((Component)this.serviceComboBox, Util.setConstraints(1, 0, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.onlinePanel.add((Component)this.emailLabel, Util.setConstraints(0, 1, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.onlinePanel.add((Component)this.emailText, Util.setConstraints(1, 1, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.onlinePanel.add((Component)this.passLabel, Util.setConstraints(0, 2, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.onlinePanel.add((Component)this.passText, Util.setConstraints(1, 2, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.onlinePanel.add((Component)this.captchaBox, Util.setConstraints(1, 3, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.onlinePanel.add((Component)this.spreadsheetNameLabel, Util.setConstraints(0, 4, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.onlinePanel.add((Component)this.spreadsheetNameText, Util.setConstraints(1, 4, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.onlinePanel.add((Component)box7, Util.setConstraints(1, 5, 0.0, 0.0, 2, 0, 5, 5, 5));
        this.captchaBox.setVisible(this.captchaToken != null);
        box4.add(jPanel4);
        box4.add(this.csvPanel);
        box4.add(jPanel5);
        box4.add(this.xlsxPanel);
        box4.add(jPanel6);
        box4.add(this.onlinePanel);
        this.outputPanel.add((Component)box4, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.exportButton);
        this.jPanelInput.add(Box.createRigidArea(new Dimension(0, 5)));
        this.jPanelInput.add(this.csvColumnsPanel);
        this.jPanelInput.add(Box.createRigidArea(new Dimension(0, 5)));
        this.jPanelInput.add(this.contentSource);
        this.jPanelInput.add(Box.createRigidArea(new Dimension(0, 5)));
        this.jPanelInput.add(this.outputPanel);
        this.jPanelInput.add(Box.createRigidArea(new Dimension(0, 5)));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)this.jPanelInput, "North");
        jPanel8.add((Component)jPanel7, "South");
        JScrollPane jScrollPane = new JScrollPane(jPanel8);
        this.add(jScrollPane);
        jScrollPane.setBorder(null);
        this.viewController.getComponentFactory().createPopupMenuDecorator().decorate(new JTextComponent[]{this.browseText, this.workspaceText, this.timestampText, this.browseOutputText, this.emailText, this.passText, this.spreadsheetNameText, this.separatorText});
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SPSHGPanel.this.initialzeFileChoosers();
            }
        });
    }

    public void setEnabledWorkspace(boolean bl) {
        ((TitledBorder)this.versioningPanel.getBorder()).setTitleColor(bl ? UIManager.getColor("TitledBorder.titleColor") : UIManager.getColor("Label.disabledForeground"));
        this.versioningPanel.repaint();
        this.workspaceLabel.setEnabled(bl);
        this.workspaceText.setEnabled(bl);
        this.timestampLabel.setEnabled(bl);
        this.timestampText.setEnabled(bl);
    }

    private void createPopupMenu() {
        this.separatorListPopup.removeAll();
        SeparatorPhrase.getInstance().load();
        Set<String> set = SeparatorPhrase.getInstance().getNicknames();
        for (String string : set) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new PopupPhraseActionListener(this.separatorText, string));
            this.separatorListPopup.add(jMenuItem);
        }
    }

    public void switchLocale() {
        this.resetPreferedSize();
        this.csvColumnsPanel.setBorder(BorderFactory.createTitledBorder(Util.I18N.getString("spshg.csvcolumns.border")));
        this.templateLabel.setText(Util.I18N.getString("spshg.csvcolumns.usetemplate"));
        this.browseButton.setText(Util.I18N.getString("spshg.button.browse"));
        this.editTemplateButton.setText(Util.I18N.getString("spshg.button.edit"));
        this.manuallyTemplateButton.setText(Util.I18N.getString("spshg.button.new"));
        this.upButton.setText(Util.I18N.getString("spshg.button.up"));
        this.downButton.setText(Util.I18N.getString("spshg.button.down"));
        this.editButton.setText(Util.I18N.getString("spshg.button.edit"));
        this.addButton.setText(Util.I18N.getString("spshg.button.add"));
        this.removeButton.setText(Util.I18N.getString("spshg.button.remove"));
        this.saveButton.setText(Util.I18N.getString("spshg.button.save"));
        this.saveMessage.setText(Util.I18N.getString("spshg.csvcolumns.manual.save"));
        this.contentSource.setBorder(BorderFactory.createTitledBorder(Util.I18N.getString("spshg.border.contentsource")));
        this.gfPrefLabel.setText("<html>" + Util.I18N.getString("spshg.contentsource.generatedatafor.prefix") + "</html>");
        this.versioningPanel.setBorder(BorderFactory.createTitledBorder(Util.I18N.getString("common.border.versioning")));
        this.workspaceLabel.setText(Util.I18N.getString("common.label.workspace"));
        this.timestampLabel.setText(Util.I18N.getString("common.label.timestamp"));
        this.bbXPanel.setBorder((Border)BorderFactory.createTitledBorder(Util.I18N.getString("spshg.bbxPanel.border")));
        this.outputPanel.setBorder(BorderFactory.createTitledBorder(Util.I18N.getString("spshg.outputPanel.border")));
        this.csvRadioButton.setText(Util.I18N.getString("spshg.csvPanel.border"));
        this.xlsxRadioButton.setText(Util.I18N.getString("spshg.xlsxPanel.border"));
        this.onlineRadioButton.setText(Util.I18N.getString("spshg.onlinePanel.border"));
        this.serviceType.setText(Util.I18N.getString("spshg.onlinePanel.cloudserver"));
        this.onlineRadioButton.setToolTipText(Util.I18N.getString("spshg.onlinePanel.tooltip"));
        this.separatorLabel.setText(Util.I18N.getString("spshg.csvPanel.separator"));
        this.browseOutputLabel.setText(Util.I18N.getString("spshg.csvPanel.browselabel"));
        this.browseOutputButton.setText(Util.I18N.getString("spshg.button.browse"));
        this.xlsxBrowseOutputButton.setText(Util.I18N.getString("spshg.button.browse"));
        this.separatorText.setText(Util.I18N.getString("spshg.csvPanel.separator.comma"));
        this.emailLabel.setText(Util.I18N.getString("spshg.onlinePanel.email"));
        this.passLabel.setText(Util.I18N.getString("spshg.onlinePanel.password"));
        this.spreadsheetNameLabel.setText(Util.I18N.getString("spshg.onlinePanel.spreadsheetName"));
        this.linkToSpSheetButton.setToolTipText(Util.I18N.getString("spshg.button.copylink.tooltip"));
        this.privacyButton.setToolTipText(Util.I18N.getString("spshg.button.share.tooltip"));
        this.exportButton.setText(Util.I18N.getString("spshg.button.export"));
        if (this.tableDataModel != null) {
            this.tableDataModel.updateColumnsTitle();
            this.modifyTableColumnsSize();
        }
        this.alignGUI();
        this.createPopupMenu();
        this.updateSelectedCityObjectLable();
    }

    private void alignGUI() {
        int n = Math.max(this.rightHandMenu.getPreferredSize().width, this.browseButton.getPreferredSize().width);
        this.rightHandMenu.setPreferredSize(new Dimension(n, this.rightHandMenu.getPreferredSize().height));
        this.browseButton.setPreferredSize(new Dimension(n, this.browseButton.getPreferredSize().height));
        this.saveButton.setPreferredSize(new Dimension(n, this.saveButton.getPreferredSize().height));
        this.browseOutputButton.setPreferredSize(new Dimension(n, this.browseOutputButton.getPreferredSize().height));
        this.xlsxBrowseOutputButton.setPreferredSize(new Dimension(n, this.xlsxBrowseOutputButton.getPreferredSize().height));
        this.scrollPane.setPreferredSize(new Dimension(this.browseText.getPreferredSize().width, 140));
        this.editTemplateButton.setPreferredSize(new Dimension(n, this.editTemplateButton.getPreferredSize().height));
        this.manuallyTemplateButton.setPreferredSize(new Dimension(n, this.manuallyTemplateButton.getPreferredSize().height));
    }

    private void modifyTableColumnsSize() {
        TableColumn tableColumn = null;
        this.table.setRowHeight(15);
        this.table.setSurrendersFocusOnKeystroke(true);
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(30);
        tableColumn.setPreferredWidth(30);
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(140);
        tableColumn.setMinWidth(140);
    }

    private void resetPreferedSize() {
        this.rightHandMenu.setPreferredSize(null);
        this.browseButton.setPreferredSize(null);
        this.saveButton.setPreferredSize(null);
        this.browseOutputButton.setPreferredSize(null);
        this.xlsxBrowseOutputButton.setPreferredSize(null);
        this.scrollPane.setPreferredSize(null);
        this.editTemplateButton.setPreferredSize(null);
        this.manuallyTemplateButton.setPreferredSize(null);
    }

    private void clearGui() {
        this.browseText.setText("");
        this.workspaceText.setText("LIVE");
        this.timestampText.setText("");
        this.spreadsheetNameText.setText("");
        this.csvRadioButton.setSelected(true);
        this.serviceComboBox.setSelectedIndex(0);
        this.emailText.setText("");
        this.passText.setText("");
        this.spreadsheetNameText.setText("");
        this.setOutputEnabledValues();
    }

    private void addListeners() {
        this.enableEvents(64L);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        SPSHGPanel.this.doExport();
                    }
                };
                thread.start();
            }
        });
        this.editGenerateData.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SPSHGPanel.this.cityObjectPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SPSHGPanel.this.choseTemplateFile()) {
                    SPSHGPanel.this.config.getTemplate().setManualTemplate(false);
                    SPSHGPanel.this.setOutputEnabledValues();
                }
            }
        });
        this.browseOutputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SPSHGPanel.this.outputFile();
            }
        });
        this.xlsxBrowseOutputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SPSHGPanel.this.xlsxOutputFile();
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SPSHGPanel.this.setOutputEnabledValues();
            }
        };
        this.csvRadioButton.addActionListener(actionListener);
        this.xlsxRadioButton.addActionListener(actionListener);
        this.onlineRadioButton.addActionListener(actionListener);
        this.editTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SPSHGPanel.this.isFilePathValid(SPSHGPanel.this.browseText.getText())) {
                    SPSHGPanel.this.config.getTemplate().setManualTemplate(true);
                    SPSHGPanel.this.loadExistingTemplate();
                    SPSHGPanel.this.setOutputEnabledValues();
                } else if (SPSHGPanel.this.choseTemplateFile()) {
                    SPSHGPanel.this.config.getTemplate().setManualTemplate(true);
                    SPSHGPanel.this.loadExistingTemplate();
                    SPSHGPanel.this.setOutputEnabledValues();
                } else {
                    SPSHGPanel.this.config.getTemplate().setManualTemplate(false);
                }
            }
        });
        this.manuallyTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SPSHGPanel.this.makeNewTemplate();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SPSHGPanel.this.showAddNewColumnDialog(false);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SPSHGPanel.this.removeSelectedColumenFromManualTemolate();
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SPSHGPanel.this.table.getSelectedRowCount() > 1) {
                    return;
                }
                int n = SPSHGPanel.this.table.getSelectedRow();
                SPSHGPanel.this.tableDataModel.move(n, true);
                if (--n >= 0) {
                    SPSHGPanel.this.table.setRowSelectionInterval(n, n);
                }
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SPSHGPanel.this.table.getSelectedRowCount() > 1) {
                    return;
                }
                int n = SPSHGPanel.this.table.getSelectedRow();
                SPSHGPanel.this.tableDataModel.move(n, false);
                if (++n <= SPSHGPanel.this.table.getRowCount() - 1) {
                    SPSHGPanel.this.table.setRowSelectionInterval(n, n);
                }
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SPSHGPanel.this.showAddNewColumnDialog(true);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getComponent().isEnabled() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    SPSHGPanel.this.showAddNewColumnDialog(true);
                }
            }
        });
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                SPSHGPanel.this.modifyButtonsVisibility();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SPSHGPanel.this.modifyButtonsVisibility();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SPSHGPanel.this.saveManuallyGeneratedTemplate();
            }
        });
        this.predefiendLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SPSHGPanel.this.separatorListPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
    }

    public void panelIsVisible(boolean bl) {
    }

    private void makeNewTemplate() {
        this.config.getTemplate().setManualTemplate(true);
        this.tableDataModel.reset();
        this.setOutputEnabledValues();
        this.browseText.setEnabled(false);
    }

    public void modifyButtonsVisibility() {
        this.checkButtonsVisibilityInManuallTemplate();
        if (this.table.getSelectedRowCount() != 1) {
            this.editButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        if (this.table.getSelectionModel().getMaxSelectionIndex() == this.tableDataModel.getRowCount() - 1 && this.tableDataModel.getRowCount() > 0) {
            this.downButton.setEnabled(false);
        }
        if (this.table.getSelectionModel().getMinSelectionIndex() == 0) {
            this.upButton.setEnabled(false);
        }
    }

    public void checkButtonsVisibilityInManuallTemplate() {
        if (this.tableDataModel.getRowCount() == 0 || this.table.getSelectedRowCount() == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doExport() {
        block49: {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            block44: {
                                block43: {
                                    block42: {
                                        block41: {
                                            block40: {
                                                var1_1 = this.mainLock;
                                                var1_1.lock();
                                                this.saveSettings();
                                                this.viewController.clearConsole();
                                                if (this.config.getTemplate().isManualTemplate()) break block40;
                                                if (this.config.getTemplate().getPath().trim().equals("")) {
                                                    this.errorMessage(Util.I18N.getString("spshg.dialog.error.incompleteData"), Util.I18N.getString("spshg.dialog.error.incompleteData.template.file"));
                                                    var1_1.unlock();
                                                    return;
                                                }
                                                break block41;
                                            }
                                            if (this.config.getTemplate().getColumnsList().size() != 0) break block41;
                                            this.errorMessage(Util.I18N.getString("spshg.dialog.error.incompleteData"), Util.I18N.getString("spshg.dialog.error.incompleteData.template.mabually"));
                                            var1_1.unlock();
                                            return;
                                        }
                                        if (SelectedCityObjects.getInstance().getSelectedCityObjects().size() != 0) break block42;
                                        this.errorMessage(Util.I18N.getString("spshg.dialog.error.incompleteData"), Util.I18N.getString("spshg.dialog.error.incompleteData.featureclass"));
                                        var1_1.unlock();
                                        return;
                                    }
                                    if (Util.checkWorkspaceTimestamp(this.config.getWorkspace().getTimestamp())) break block43;
                                    this.errorMessage(Util.I18N.getString("common.dialog.error.incorrectData"), Util.I18N.getString("common.dialog.error.incorrectData.date"));
                                    var1_1.unlock();
                                    return;
                                }
                                if (this.config.getBoundingbox().getLowerLeftCorner().isSetX() || this.config.getBoundingbox().getLowerLeftCorner().isSetY() || this.config.getBoundingbox().getUpperRightCorner().isSetX() || this.config.getBoundingbox().getUpperRightCorner().isSetY()) break block44;
                                this.errorMessage(Util.I18N.getString("spshg.dialog.error.incompleteData"), Util.I18N.getString("spshg.dialog.error.incompleteData.bbx"));
                                var1_1.unlock();
                                return;
                            }
                            if (this.config.getOutput().getType() != "CSV_FILE") ** GOTO lbl71
                            if (!this.config.getOutput().getCsvfile().getOutputPath().trim().equals("")) break block45;
                            this.errorMessage(Util.I18N.getString("spshg.dialog.error.incompleteData"), Util.I18N.getString("spshg.dialog.error.incompleteData.csvout"));
                            var1_1.unlock();
                            return;
                        }
                        if (!this.config.getOutput().getCsvfile().getSeparator().trim().equals("")) break block46;
                        this.errorMessage(Util.I18N.getString("spshg.dialog.error.incompleteData"), Util.I18N.getString("spshg.dialog.error.incompleteData.seperatorChar"));
                        var1_1.unlock();
                        return;
                    }
                    var2_2 = "";
                    var3_8 = this.config.getOutput().getCsvfile().getOutputPath().trim();
                    if (var3_8.lastIndexOf(File.separator) == -1) {
                        var2_2 = var3_8;
                        var3_8 = ".";
                    } else {
                        var2_2 = var3_8.lastIndexOf(".") == -1 ? var3_8.substring(var3_8.lastIndexOf(File.separator) + 1) : var3_8.substring(var3_8.lastIndexOf(File.separator) + 1, var3_8.lastIndexOf("."));
                        var3_8 = var3_8.substring(0, var3_8.lastIndexOf(File.separator));
                    }
                    var4_9 = new File((String)var3_8 + File.separator + var2_2 + ".csv");
                    if (!var4_9.exists() || (var5_10 = JOptionPane.showConfirmDialog(this.viewController.getTopFrame(), String.format(Util.I18N.getString("spshg.dialog.error.csvfile.exist.message"), new Object[]{var4_9.getPath()}), Util.I18N.getString("spshg.dialog.error.csvfile.exist.title"), 0)) == 0) break block47;
                    var1_1.unlock();
                    return;
                }
                ** GOTO lbl104
                catch (Exception var2_3) {
                    this.errorMessage("Error", "Error during creating the output CSV file.");
                    ** GOTO lbl104
                }
lbl71:
                // 1 sources

                if (this.config.getOutput().getType() != "XLSX_FILE") ** GOTO lbl96
                if (!this.config.getOutput().getXlsxfile().getOutputPath().trim().equals("")) break block48;
                this.errorMessage(Util.I18N.getString("spshg.dialog.error.incompleteData"), Util.I18N.getString("spshg.dialog.error.incompleteData.csvout"));
                var1_1.unlock();
                return;
            }
            var2_2 = "";
            var3_8 = this.config.getOutput().getXlsxfile().getOutputPath().trim();
            if (var3_8.lastIndexOf(File.separator) == -1) {
                var2_2 = var3_8;
                var3_8 = ".";
            } else {
                var2_2 = var3_8.lastIndexOf(".") == -1 ? var3_8.substring(var3_8.lastIndexOf(File.separator) + 1) : var3_8.substring(var3_8.lastIndexOf(File.separator) + 1, var3_8.lastIndexOf("."));
                var3_8 = var3_8.substring(0, var3_8.lastIndexOf(File.separator));
            }
            var4_9 = new File((String)var3_8 + File.separator + var2_2 + ".xlsx");
            if (!var4_9.exists() || (var5_10 = JOptionPane.showConfirmDialog(this.viewController.getTopFrame(), String.format(Util.I18N.getString("spshg.dialog.error.csvfile.exist.message"), new Object[]{var4_9.getPath()}), Util.I18N.getString("spshg.dialog.error.csvfile.exist.title"), 0)) == 0) break block49;
            var1_1.unlock();
            return;
        }
        try {
            block50: {
                break block50;
                catch (Exception var2_4) {
                    this.errorMessage("Error", "Error during creating the output XLSX file.");
                    break block50;
                }
lbl96:
                // 1 sources

                if (!CloudServiceRegistery.getInstance().isServiceSelected()) {
                    this.errorMessage(Util.I18N.getString("spshg.dialog.error.incompleteData"), Util.I18N.getString("spshg.dialog.error.incompleteData.online.cloudservice"));
                    return;
                }
                if (this.config.getOutput().getCloud().getSpreadsheetName() == null || this.config.getOutput().getCloud().getSpreadsheetName().trim().equals("")) {
                    this.errorMessage(Util.I18N.getString("spshg.dialog.error.incompleteData"), Util.I18N.getString("spshg.dialog.error.incompleteData.online.spname"));
                    return;
                }
                if (!this.authenticate(this.config.getOutput().getCloud().getEmail(), new String(this.passText.getPassword()))) {
                    return;
                }
            }
            if (!this.dbPool.isConnected()) {
                try {
                    this.dbController.connect(true);
                }
                catch (DatabaseConfigurationException var2_5) {
                    var1_1.unlock();
                    return;
                }
                catch (SQLException var2_6) {
                    var1_1.unlock();
                    return;
                }
                catch (DatabaseVersionException var2_7) {
                    var1_1.unlock();
                    return;
                }
                if (!this.dbController.isConnected()) {
                    return;
                }
            }
            this.viewController.setStatusText(Util.I18N.getString("spshg.status.generation.start"));
            this.logController.info(Util.I18N.getString("spshg.message.export.init"));
            var2_2 = ObjectRegistry.getInstance().getEventDispatcher();
            var3_8 = new StatusDialog(this.viewController.getTopFrame(), Util.I18N.getString("spshg.dialog.status.title"), Util.I18N.getString("spshg.dialog.status.state.start"), Util.I18N.getString("spshg.dialog.status.message.start"), null, true);
            var3_8.setSize(226, 140);
            SwingUtilities.invokeLater(new Runnable((StatusDialog)var3_8){
                final /* synthetic */ StatusDialog val$status;
                {
                    this.val$status = statusDialog;
                }

                @Override
                public void run() {
                    this.val$status.setLocationRelativeTo(SPSHGPanel.this.viewController.getTopFrame());
                    this.val$status.setVisible(true);
                }
            });
            SeparatorPhrase.getInstance().renewTempPhrase();
            var4_9 = new SpreadsheetExporter(this.plugin);
            var3_8.getButton().addActionListener(new ActionListener((EventDispatcher)var2_2){
                final /* synthetic */ EventDispatcher val$eventDispatcher;
                {
                    this.val$eventDispatcher = eventDispatcher;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            val$eventDispatcher.triggerEvent((Event)new InterruptEvent(Util.I18N.getString("spshg.message.export.cancel"), LogLevel.INFO, this));
                        }
                    });
                }
            });
            var5_10 = (int)var4_9.doProcess();
            try {
                var2_2.flushEvents();
            }
            catch (InterruptedException var6_11) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable((StatusDialog)var3_8){
                final /* synthetic */ StatusDialog val$status;
                {
                    this.val$status = statusDialog;
                }

                @Override
                public void run() {
                    this.val$status.dispose();
                }
            });
            var4_9.cleanup();
            if (var5_10 != 0) {
                this.logController.info(Util.I18N.getString("spshg.message.export.success"));
            } else {
                this.logController.warn(Util.I18N.getString("spshg.message.export.abort"));
            }
            this.viewController.setStatusText(Util.I18N.getString("main.status.ready.label"));
        }
        finally {
            var1_1.unlock();
        }
    }

    public void updateSelectedCityObjectLable() {
        this.generateDataFor.setText(SelectedCityObjects.getInstance().getSelectedObjectsString());
    }

    public void initializeCityObjectPopup() {
        LinkedHashMap<String, Integer> linkedHashMap = SelectedCityObjects.getInstance().getChilds();
        HashSet<JCheckBoxMenuItem> hashSet = new HashSet<JCheckBoxMenuItem>();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(SelectedCityObjects.getInstance().getRoot());
        jCheckBoxMenuItem.setUI(new StayOpenCheckBoxMenuItemUI());
        PopupCityObjectActionListener popupCityObjectActionListener = new PopupCityObjectActionListener(this, SelectedCityObjects.getInstance().getRootID());
        jCheckBoxMenuItem.addActionListener(popupCityObjectActionListener);
        this.cityObjectPopup.add(jCheckBoxMenuItem);
        if (SelectedCityObjects.getInstance().isCityObjectSelected(SelectedCityObjects.getInstance().getRootID())) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(false);
        }
        this.cityObjectPopup.addSeparator();
        for (String string : linkedHashMap.keySet()) {
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(string);
            jCheckBoxMenuItem2.setUI(new StayOpenCheckBoxMenuItemUI());
            PopupCityObjectActionListener popupCityObjectActionListener2 = new PopupCityObjectActionListener(this, linkedHashMap.get(string));
            popupCityObjectActionListener2.setRootCheckBoxes(jCheckBoxMenuItem);
            jCheckBoxMenuItem2.addActionListener(popupCityObjectActionListener2);
            this.cityObjectPopup.add(jCheckBoxMenuItem2);
            if (SelectedCityObjects.getInstance().isCityObjectSelected(linkedHashMap.get(string))) {
                jCheckBoxMenuItem2.setState(true);
            } else {
                jCheckBoxMenuItem2.setState(false);
            }
            hashSet.add(jCheckBoxMenuItem2);
        }
        popupCityObjectActionListener.setAllCheckBoxes(hashSet);
    }

    private void showAddNewColumnDialog(boolean bl) {
        NewCSVColumnDialog newCSVColumnDialog;
        if (!bl) {
            newCSVColumnDialog = new NewCSVColumnDialog(this.viewController.getTopFrame(), this);
        } else {
            if (this.table.getSelectedRow() == -1 || this.table.getSelectedRowCount() > 1) {
                return;
            }
            CSVColumns cSVColumns = this.tableDataModel.getCSVColumn(this.table.getSelectedRow());
            if (cSVColumns == null) {
                return;
            }
            newCSVColumnDialog = new NewCSVColumnDialog(this.viewController.getTopFrame(), this, cSVColumns);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                newCSVColumnDialog.setLocationRelativeTo(SPSHGPanel.this.viewController.getTopFrame());
                newCSVColumnDialog.setVisible(true);
            }
        });
    }

    public void addNewColumnInManualCSV(CSVColumns cSVColumns) {
        this.tableDataModel.addNewRow(cSVColumns);
    }

    public void editColumnInManualCSV(CSVColumns cSVColumns) {
        this.tableDataModel.editRow(cSVColumns);
    }

    private void removeSelectedColumenFromManualTemolate() {
        this.tableDataModel.removeRow(this.table.getSelectedRows());
    }

    private void initialzeFileChoosers() {
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Normal text file (*.txt)", "txt");
        this.fileChooserTemplate.addChoosableFileFilter(fileNameExtensionFilter);
        this.fileChooserTemplate.addChoosableFileFilter(this.fileChooserTemplate.getAcceptAllFileFilter());
        this.fileChooserTemplate.setFileFilter(fileNameExtensionFilter);
        FileNameExtensionFilter fileNameExtensionFilter2 = new FileNameExtensionFilter("Comma-separated Values Files (*.csv)", "csv");
        this.fileChooserCSVOut.addChoosableFileFilter(fileNameExtensionFilter2);
        this.fileChooserCSVOut.addChoosableFileFilter(this.fileChooserCSVOut.getAcceptAllFileFilter());
        this.fileChooserCSVOut.setFileFilter(fileNameExtensionFilter2);
        FileNameExtensionFilter fileNameExtensionFilter3 = new FileNameExtensionFilter("Microsoft Excel Files (*.xlsx)", "xlsx");
        this.fileChooserXLSXOut.addChoosableFileFilter(fileNameExtensionFilter3);
        this.fileChooserXLSXOut.addChoosableFileFilter(this.fileChooserXLSXOut.getAcceptAllFileFilter());
        this.fileChooserXLSXOut.setFileFilter(fileNameExtensionFilter3);
    }

    private void saveManuallyGeneratedTemplate() {
        int n;
        if (this.previousvisitBySaveTemplate != null && this.previousvisitBySaveTemplate.length() > 0) {
            this.fileChooserTemplate.setCurrentDirectory(new File(this.previousvisitBySaveTemplate));
        }
        if ((n = this.fileChooserTemplate.showSaveDialog(this.getTopLevelAncestor())) == 1) {
            return;
        }
        try {
            String string = this.fileChooserTemplate.getSelectedFile().toString();
            if (string.lastIndexOf(46) != -1 && string.lastIndexOf(46) > string.lastIndexOf(File.separator)) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            this.previousvisitBySaveTemplate = string = string + ".txt";
            TemplateWriter templateWriter = new TemplateWriter(string, this.tableDataModel);
            Thread thread = new Thread(templateWriter);
            thread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean choseTemplateFile() {
        int n;
        String string = this.config.getTemplate().getLastVisitPath();
        if (string != null && string.length() > 0) {
            this.fileChooserTemplate.setCurrentDirectory(new File(string));
        }
        if ((n = this.fileChooserTemplate.showOpenDialog(this.getTopLevelAncestor())) == 1) {
            return false;
        }
        try {
            String string2 = this.fileChooserTemplate.getSelectedFile().toString();
            this.browseText.setText(string2);
            this.config.getTemplate().setLastVisitPath(this.fileChooserTemplate.getCurrentDirectory().getAbsolutePath());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void outputFile() {
        int n;
        String string = this.config.getOutput().getCsvfile().getLastVisitPath();
        if (string != null && string.length() > 0) {
            this.fileChooserCSVOut.setCurrentDirectory(new File(string).getParentFile());
        }
        if ((n = this.fileChooserCSVOut.showSaveDialog(this.getTopLevelAncestor())) == 1) {
            return;
        }
        try {
            String string2 = this.fileChooserCSVOut.getSelectedFile().toString();
            if (string2.lastIndexOf(46) != -1 && string2.lastIndexOf(46) > string2.lastIndexOf(File.separator)) {
                string2 = string2.substring(0, string2.lastIndexOf(46));
            }
            string2 = string2 + ".csv";
            this.browseOutputText.setText(string2);
            this.config.getOutput().getCsvfile().setLastVisitPath(this.fileChooserCSVOut.getCurrentDirectory().getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void xlsxOutputFile() {
        int n;
        String string = this.config.getOutput().getXlsxfile().getLastVisitPath();
        if (string != null && string.length() > 0) {
            this.fileChooserXLSXOut.setCurrentDirectory(new File(string).getParentFile());
        }
        if ((n = this.fileChooserXLSXOut.showSaveDialog(this.getTopLevelAncestor())) == 1) {
            return;
        }
        try {
            String string2 = this.fileChooserXLSXOut.getSelectedFile().toString();
            if (string2.lastIndexOf(46) != -1 && string2.lastIndexOf(46) > string2.lastIndexOf(File.separator)) {
                string2 = string2.substring(0, string2.lastIndexOf(46));
            }
            string2 = string2 + ".xlsx";
            this.xlsxBrowseOutputText.setText(string2);
            this.config.getOutput().getXlsxfile().setLastVisitPath(this.fileChooserXLSXOut.getCurrentDirectory().getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setAfterUploadPanelEnable(boolean bl) {
        this.linkToSpSheetButton.setEnabled(bl);
        bl = bl && CloudServiceRegistery.getInstance().isServiceSelected() && CloudServiceRegistery.getInstance().getSelectedService().isPolicyChangeable();
        this.privacyButton.setEnabled(bl);
    }

    public boolean isSuccessfullyUploaded() {
        return this.successUpload;
    }

    private void setOutputEnabledValues() {
        this.browseText.setEnabled(true);
        this.manualPanel.setVisible(this.config.getTemplate().isManualTemplate());
        if (this.config.getTemplate().isManualTemplate()) {
            this.checkButtonsVisibilityInManuallTemplate();
        }
        this.browseOutputButton.setEnabled(this.csvRadioButton.isSelected());
        this.browseOutputText.setEnabled(this.csvRadioButton.isSelected());
        this.browseOutputLabel.setEnabled(this.csvRadioButton.isSelected());
        this.separatorLabel.setEnabled(this.csvRadioButton.isSelected());
        this.separatorText.setEnabled(this.csvRadioButton.isSelected());
        this.predefiendLabel.setEnabled(this.csvRadioButton.isSelected());
        this.xlsxBrowseOutputButton.setEnabled(this.xlsxRadioButton.isSelected());
        this.xlsxBrowseOutputText.setEnabled(this.xlsxRadioButton.isSelected());
        this.serviceType.setEnabled(this.onlineRadioButton.isSelected());
        this.serviceComboBox.setEnabled(this.onlineRadioButton.isSelected());
        this.emailLabel.setEnabled(this.onlineRadioButton.isSelected());
        this.emailText.setEnabled(this.onlineRadioButton.isSelected());
        this.passLabel.setEnabled(this.onlineRadioButton.isSelected());
        this.passText.setEnabled(this.onlineRadioButton.isSelected());
        this.spreadsheetNameLabel.setEnabled(this.onlineRadioButton.isSelected());
        this.spreadsheetNameText.setEnabled(this.onlineRadioButton.isSelected());
        this.setAfterUploadPanelEnable(this.successUpload);
    }

    public ImageIcon createImageIcon(String string, String string2) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(560, 780);
    }

    public void loadSettings() {
        this.config = this.plugin.getConfig();
        if (this.config == null) {
            return;
        }
        SelectedCityObjects.getInstance().initialize(this.config);
        this.initializeCityObjectPopup();
        this.browseText.setText(this.config.getTemplate().getPath());
        this.workspaceText.setText(this.config.getWorkspace().getName());
        this.timestampText.setText(this.config.getWorkspace().getTimestamp());
        this.bbXPanel.setBoundingBox(this.config.getBoundingbox());
        this.browseOutputText.setText(this.config.getOutput().getCsvfile().getOutputPath());
        this.separatorText.setText(this.config.getOutput().getCsvfile().getSeparator());
        this.xlsxBrowseOutputText.setText(this.config.getOutput().getXlsxfile().getOutputPath());
        this.csvRadioButton.setSelected(true);
        if (this.config.getOutput().getType().equalsIgnoreCase("XLSX_FILE")) {
            this.xlsxRadioButton.setSelected(true);
        }
        if (this.config.getOutput().getType().equalsIgnoreCase("INTOCLOUD")) {
            this.onlineRadioButton.setSelected(true);
        }
        this.serviceComboBox.setSelectedItem(this.config.getOutput().getCloud().getServiceName());
        this.emailText.setText(this.config.getOutput().getCloud().getEmail());
        this.passText.setText("");
        this.spreadsheetNameText.setText(this.config.getOutput().getCloud().getSpreadsheetName());
        this.setOutputEnabledValues();
    }

    public void saveSettings() {
        if (this.config == null) {
            return;
        }
        this.config.getTemplate().setPath(this.browseText.getText());
        this.config.getTemplate().setColumnsList(this.tableDataModel.getRows());
        this.config.getWorkspace().setName(this.workspaceText.getText());
        this.config.getWorkspace().setTimestamp(this.timestampText.getText());
        this.config.setBoundingbox(this.bbXPanel.getBoundingBox());
        if (this.csvRadioButton.isSelected()) {
            this.config.getOutput().setType("CSV_FILE");
        } else if (this.xlsxRadioButton.isSelected()) {
            this.config.getOutput().setType("XLSX_FILE");
        } else {
            this.config.getOutput().setType("INTOCLOUD");
        }
        this.config.getOutput().getCsvfile().setOutputPath(this.browseOutputText.getText());
        this.config.getOutput().getCsvfile().setSeparator(this.separatorText.getText());
        this.config.getOutput().getXlsxfile().setOutputPath(this.xlsxBrowseOutputText.getText());
        this.config.getOutput().getCloud().setServiceName((String)this.serviceComboBox.getSelectedItem());
        CloudServiceRegistery.getInstance().selectService((String)this.serviceComboBox.getSelectedItem());
        this.config.getOutput().getCloud().setEmail(this.emailText.getText());
        this.config.getOutput().getCloud().setSpreadsheetName(this.spreadsheetNameText.getText());
    }

    private void errorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this.viewController.getTopFrame(), string2, string, 0);
    }

    private boolean authenticate(String string, String string2) {
        try {
            if (this.captchaToken == null) {
                CloudServiceRegistery.getInstance().getSelectedService().setUserCredentials(string, string2);
            } else {
                CloudServiceRegistery.getInstance().getSelectedService().setUserCredentials(string, string2, this.captchaToken, this.captchaText.getText());
            }
            this.logController.info(Util.I18N.getString("spshg.message.authentication.success"));
            this.captchaToken = null;
            this.captchaBox.setVisible(this.captchaToken != null);
            return true;
        }
        catch (CaptchaRequiredException captchaRequiredException) {
            this.captchaToken = captchaRequiredException.getCaptchaToken();
            this.captchaBox.setVisible(this.captchaToken != null);
            try {
                this.captchaImage.setIcon(new ImageIcon(new URL(captchaRequiredException.getCaptchaUrl())));
                this.captchaText.setText(Util.I18N.getString("spshg.dialog.error.incompleteData.online.captcha"));
            }
            catch (IOException iOException) {
                this.captchaImage.setText("(Error parsing captcha image URL)");
            }
            return false;
        }
        catch (AuthenticationException authenticationException) {
            this.captchaToken = null;
            this.captchaBox.setVisible(this.captchaToken != null);
            this.logController.error(Util.I18N.getString("spshg.message.authentication.userpass") + "\n More info: " + authenticationException.getMessage());
            return false;
        }
    }

    public void customButtonClicked(int n) {
        switch (n) {
            case 1: {
                Util.clipboard.copy(this.uploadResultURL);
                this.logController.info(Util.I18N.getString("spshg.message.info.copylink"));
                return;
            }
            case 2: {
                if (!CloudServiceRegistery.getInstance().isServiceSelected()) {
                    return;
                }
                final JDialog jDialog = CloudServiceRegistery.getInstance().getSelectedService().getPolicyEditorUI(this.viewController.getTopFrame());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jDialog.setLocationRelativeTo(SPSHGPanel.this.viewController.getTopFrame());
                        jDialog.setVisible(true);
                    }
                });
                return;
            }
        }
    }

    public void handleEvent(Event event) throws Exception {
        if (event.getEventType() == EventType.UPLOAD_EVENT) {
            if (((UploadEvent)event).isSuccess()) {
                this.successUpload = true;
                this.uploadResultURL = ((UploadEvent)event).getURL();
            } else {
                this.successUpload = false;
                this.uploadResultURL = "";
            }
            this.setAfterUploadPanelEnable(this.successUpload);
        } else if (event.getEventType() == GlobalEvents.DATABASE_CONNECTION_STATE) {
            DatabaseConnectionStateEvent databaseConnectionStateEvent = (DatabaseConnectionStateEvent)event;
            this.setEnabledWorkspace(!databaseConnectionStateEvent.isConnected() || databaseConnectionStateEvent.isConnected() && this.dbPool.getActiveDatabaseAdapter().hasVersioningSupport());
        }
    }

    public void loadExistingTemplate() {
        if (this.browseText.getText() == null || this.browseText.getText().trim().length() < 1) {
            return;
        }
        final File file = new File(this.browseText.getText().trim());
        if (file == null || !file.exists()) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String string;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                    SPSHGPanel.this.tableDataModel.reset();
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = "";
                    String string3 = "";
                    while ((string = bufferedReader.readLine()) != null) {
                        try {
                            string2 = "";
                            string3 = "";
                            if (string.startsWith("//") || string.startsWith(";")) {
                                if (string.startsWith("//")) {
                                    stringBuffer.append(string.substring(2));
                                } else {
                                    stringBuffer.append(string.substring(1));
                                }
                                stringBuffer.append(System.getProperty("line.separator"));
                                continue;
                            }
                            if (string.indexOf(58) > 0) {
                                string2 = string.substring(0, string.indexOf(58));
                                string3 = string.substring(string.indexOf(58) + 1, string.length());
                            } else {
                                string3 = string;
                                string2 = Translator.getInstance().getProperHeader(string3);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (stringBuffer.length() > 0) {
                            stringBuffer.setLength(stringBuffer.lastIndexOf(System.getProperty("line.separator")));
                        }
                        SPSHGPanel.this.tableDataModel.addNewRow(new CSVColumns(string2, string3, stringBuffer.substring(0), Translator.getInstance().getFormatedDocument(string3)));
                        stringBuffer.setLength(0);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    private boolean isFilePathValid(String string) {
        try {
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            File file = new File(string);
            return file.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

