/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.gui.datatype;

import java.util.HashSet;
import java.util.LinkedHashMap;
import org.citydb.plugins.spreadsheet_gen.config.ConfigImpl;
import org.citydb.plugins.spreadsheet_gen.config.FeatureClass;
import org.citygml4j.model.citygml.CityGMLClass;

public class SelectedCityObjects {
    private final int Cityobject = 1;
    private final int Building = 2;
    private final int WaterBody = 3;
    private final int LandUse = 4;
    private final int Vegetation = 5;
    private final int Transportation = 6;
    private final int ReliefFeature = 7;
    private final int CityFurniture = 8;
    private final int GenericCityObject = 9;
    private final int CityObjectGroup = 10;
    private final int Tunnel = 11;
    private final int Bridge = 12;
    private HashSet<CityGMLClass> desireCityObjects = new HashSet();
    private LinkedHashMap<String, Integer> allitems = new LinkedHashMap();
    private static final SelectedCityObjects instance = new SelectedCityObjects();
    private FeatureClass fc;

    SelectedCityObjects() {
        this.allitems.put(this.getName(2), new Integer(this.Building));
        this.allitems.put(this.getName(3), new Integer(this.WaterBody));
        this.allitems.put(this.getName(4), new Integer(this.LandUse));
        this.allitems.put(this.getName(5), new Integer(this.Vegetation));
        this.allitems.put(this.getName(6), new Integer(this.Transportation));
        this.allitems.put(this.getName(7), new Integer(this.ReliefFeature));
        this.allitems.put(this.getName(8), new Integer(this.CityFurniture));
        this.allitems.put(this.getName(9), new Integer(this.GenericCityObject));
        this.allitems.put(this.getName(10), new Integer(this.CityObjectGroup));
        this.allitems.put(this.getName(11), new Integer(this.Tunnel));
        this.allitems.put(this.getName(12), new Integer(this.Bridge));
    }

    public static SelectedCityObjects getInstance() {
        return instance;
    }

    public void initialize(ConfigImpl configImpl) {
        this.fc = configImpl.getSelectedcityobjects();
        if (this.fc.isSetBuilding()) {
            this.selectCityObject(2);
        } else {
            this.removeCityObject(2);
        }
        if (this.fc.isSetWaterBody()) {
            this.selectCityObject(3);
        } else {
            this.removeCityObject(3);
        }
        if (this.fc.isSetLandUse()) {
            this.selectCityObject(4);
        } else {
            this.removeCityObject(4);
        }
        if (this.fc.isSetVegetation()) {
            this.selectCityObject(5);
        } else {
            this.removeCityObject(5);
        }
        if (this.fc.isSetTransportation()) {
            this.selectCityObject(6);
        } else {
            this.removeCityObject(6);
        }
        if (this.fc.isSetReliefFeature()) {
            this.selectCityObject(7);
        } else {
            this.removeCityObject(7);
        }
        if (this.fc.isSetCityFurniture()) {
            this.selectCityObject(8);
        } else {
            this.removeCityObject(8);
        }
        if (this.fc.isSetGenericCityObject()) {
            this.selectCityObject(9);
        } else {
            this.removeCityObject(9);
        }
        if (this.fc.isSetBuilding()) {
            this.selectCityObject(2);
        } else {
            this.removeCityObject(2);
        }
        if (this.fc.isSetTunnel()) {
            this.selectCityObject(11);
        } else {
            this.removeCityObject(11);
        }
        if (this.fc.isSetBridge()) {
            this.selectCityObject(12);
        } else {
            this.removeCityObject(12);
        }
    }

    public HashSet<CityGMLClass> getSelectedCityObjects() {
        return this.desireCityObjects;
    }

    public String getSelectedObjectsString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : this.allitems.keySet()) {
            if (!this.isCityObjectSelected(this.allitems.get(string))) continue;
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(string.trim());
        }
        return stringBuffer.toString();
    }

    public void selectCityObject(Integer n) {
        this.selectCityObject((int)n);
        this.saveSetting(n, true);
    }

    public void removeCityObject(Integer n) {
        this.removeCityObject((int)n);
        this.saveSetting(n, false);
    }

    public String getRoot() {
        return this.getName(1);
    }

    public int getRootID() {
        return 1;
    }

    public LinkedHashMap<String, Integer> getChilds() {
        return this.allitems;
    }

    public boolean isCityObjectSelected(Integer n) {
        switch (n) {
            case 1: {
                return this.fc.isSetBuilding() && this.fc.isSetCityFurniture() && this.fc.isSetLandUse() && this.fc.isSetWaterBody() && this.fc.isSetVegetation() && this.fc.isSetTransportation() && this.fc.isSetReliefFeature() && this.fc.isSetGenericCityObject() && this.fc.isSetCityObjectGroup() && this.fc.isSetTunnel() && this.fc.isSetBridge();
            }
            case 2: {
                return this.fc.isSetBuilding();
            }
            case 8: {
                return this.fc.isSetCityFurniture();
            }
            case 4: {
                return this.fc.isSetLandUse();
            }
            case 3: {
                return this.fc.isSetWaterBody();
            }
            case 5: {
                return this.fc.isSetVegetation();
            }
            case 6: {
                return this.fc.isSetTransportation();
            }
            case 7: {
                return this.fc.isSetReliefFeature();
            }
            case 9: {
                return this.fc.isSetGenericCityObject();
            }
            case 10: {
                return this.fc.isSetCityObjectGroup();
            }
            case 11: {
                return this.fc.isSetTunnel();
            }
            case 12: {
                return this.fc.isSetBridge();
            }
        }
        return false;
    }

    private void removeCityObject(int n) {
        switch (n) {
            case 1: {
                this.desireCityObjects.remove(CityGMLClass.BUILDING);
                this.desireCityObjects.remove(CityGMLClass.CITY_FURNITURE);
                this.desireCityObjects.remove(CityGMLClass.LAND_USE);
                this.desireCityObjects.remove(CityGMLClass.WATER_BODY);
                this.desireCityObjects.remove(CityGMLClass.PLANT_COVER);
                this.desireCityObjects.remove(CityGMLClass.SOLITARY_VEGETATION_OBJECT);
                this.desireCityObjects.remove(CityGMLClass.TRANSPORTATION_COMPLEX);
                this.desireCityObjects.remove(CityGMLClass.ROAD);
                this.desireCityObjects.remove(CityGMLClass.RAILWAY);
                this.desireCityObjects.remove(CityGMLClass.TRACK);
                this.desireCityObjects.remove(CityGMLClass.SQUARE);
                this.desireCityObjects.remove(CityGMLClass.RELIEF_FEATURE);
                this.desireCityObjects.remove(CityGMLClass.GENERIC_CITY_OBJECT);
                this.desireCityObjects.remove(CityGMLClass.CITY_OBJECT_GROUP);
                this.desireCityObjects.remove(CityGMLClass.TUNNEL);
                this.desireCityObjects.remove(CityGMLClass.BRIDGE);
                return;
            }
            case 2: {
                this.desireCityObjects.remove(CityGMLClass.BUILDING);
                return;
            }
            case 8: {
                this.desireCityObjects.remove(CityGMLClass.CITY_FURNITURE);
                return;
            }
            case 4: {
                this.desireCityObjects.remove(CityGMLClass.LAND_USE);
                return;
            }
            case 3: {
                this.desireCityObjects.remove(CityGMLClass.WATER_BODY);
                return;
            }
            case 5: {
                this.desireCityObjects.remove(CityGMLClass.PLANT_COVER);
                this.desireCityObjects.remove(CityGMLClass.SOLITARY_VEGETATION_OBJECT);
                return;
            }
            case 6: {
                this.desireCityObjects.remove(CityGMLClass.TRANSPORTATION_COMPLEX);
                this.desireCityObjects.remove(CityGMLClass.ROAD);
                this.desireCityObjects.remove(CityGMLClass.RAILWAY);
                this.desireCityObjects.remove(CityGMLClass.TRACK);
                this.desireCityObjects.remove(CityGMLClass.SQUARE);
                return;
            }
            case 7: {
                this.desireCityObjects.remove(CityGMLClass.RELIEF_FEATURE);
                return;
            }
            case 9: {
                this.desireCityObjects.remove(CityGMLClass.GENERIC_CITY_OBJECT);
                return;
            }
            case 10: {
                this.desireCityObjects.remove(CityGMLClass.CITY_OBJECT_GROUP);
                return;
            }
            case 11: {
                this.desireCityObjects.remove(CityGMLClass.TUNNEL);
                return;
            }
            case 12: {
                this.desireCityObjects.remove(CityGMLClass.BRIDGE);
                return;
            }
        }
    }

    private void saveSetting(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.fc.setBuilding(bl);
                this.fc.setCityFurniture(bl);
                this.fc.setLandUse(bl);
                this.fc.setWaterBody(bl);
                this.fc.setVegetation(bl);
                this.fc.setTransportation(bl);
                this.fc.setReliefFeature(bl);
                this.fc.setGenericCityObject(bl);
                this.fc.setCityObjectGroup(bl);
                this.fc.setTunnel(bl);
                this.fc.setBridge(bl);
                return;
            }
            case 2: {
                this.fc.setBuilding(bl);
                return;
            }
            case 8: {
                this.fc.setCityFurniture(bl);
                return;
            }
            case 4: {
                this.fc.setLandUse(bl);
                return;
            }
            case 3: {
                this.fc.setWaterBody(bl);
                return;
            }
            case 5: {
                this.fc.setVegetation(bl);
                return;
            }
            case 6: {
                this.fc.setTransportation(bl);
                return;
            }
            case 7: {
                this.fc.setReliefFeature(bl);
                return;
            }
            case 9: {
                this.fc.setGenericCityObject(bl);
                return;
            }
            case 10: {
                this.fc.setCityObjectGroup(bl);
                return;
            }
            case 11: {
                this.fc.setTunnel(bl);
                return;
            }
            case 12: {
                this.fc.setBridge(bl);
                return;
            }
        }
    }

    public String getName(int n) {
        String string = "    ";
        switch (n) {
            case 1: {
                return "City Object";
            }
            case 2: {
                return string + "Building";
            }
            case 8: {
                return string + "City Furniture";
            }
            case 4: {
                return string + "Land Use";
            }
            case 3: {
                return string + "Water Body";
            }
            case 5: {
                return string + "Vegetation";
            }
            case 6: {
                return string + "Transportation";
            }
            case 7: {
                return string + "Relief Feature";
            }
            case 9: {
                return string + "Generic City Object";
            }
            case 10: {
                return string + "City Object Group";
            }
            case 11: {
                return string + "Tunnel";
            }
            case 12: {
                return string + "Bridge";
            }
        }
        return "";
    }

    private void selectCityObject(int n) {
        switch (n) {
            case 1: {
                this.desireCityObjects.add(CityGMLClass.BUILDING);
                this.desireCityObjects.add(CityGMLClass.CITY_FURNITURE);
                this.desireCityObjects.add(CityGMLClass.LAND_USE);
                this.desireCityObjects.add(CityGMLClass.WATER_BODY);
                this.desireCityObjects.add(CityGMLClass.PLANT_COVER);
                this.desireCityObjects.add(CityGMLClass.SOLITARY_VEGETATION_OBJECT);
                this.desireCityObjects.add(CityGMLClass.TRANSPORTATION_COMPLEX);
                this.desireCityObjects.add(CityGMLClass.ROAD);
                this.desireCityObjects.add(CityGMLClass.RAILWAY);
                this.desireCityObjects.add(CityGMLClass.TRACK);
                this.desireCityObjects.add(CityGMLClass.SQUARE);
                this.desireCityObjects.add(CityGMLClass.RELIEF_FEATURE);
                this.desireCityObjects.add(CityGMLClass.GENERIC_CITY_OBJECT);
                this.desireCityObjects.add(CityGMLClass.CITY_OBJECT_GROUP);
                this.desireCityObjects.add(CityGMLClass.TUNNEL);
                this.desireCityObjects.add(CityGMLClass.BRIDGE);
                return;
            }
            case 2: {
                this.desireCityObjects.add(CityGMLClass.BUILDING);
                return;
            }
            case 8: {
                this.desireCityObjects.add(CityGMLClass.CITY_FURNITURE);
                return;
            }
            case 4: {
                this.desireCityObjects.add(CityGMLClass.LAND_USE);
                return;
            }
            case 3: {
                this.desireCityObjects.add(CityGMLClass.WATER_BODY);
                return;
            }
            case 5: {
                this.desireCityObjects.add(CityGMLClass.PLANT_COVER);
                this.desireCityObjects.add(CityGMLClass.SOLITARY_VEGETATION_OBJECT);
                return;
            }
            case 6: {
                this.desireCityObjects.add(CityGMLClass.TRANSPORTATION_COMPLEX);
                this.desireCityObjects.add(CityGMLClass.ROAD);
                this.desireCityObjects.add(CityGMLClass.RAILWAY);
                this.desireCityObjects.add(CityGMLClass.TRACK);
                this.desireCityObjects.add(CityGMLClass.SQUARE);
                return;
            }
            case 7: {
                this.desireCityObjects.add(CityGMLClass.RELIEF_FEATURE);
                return;
            }
            case 9: {
                this.desireCityObjects.add(CityGMLClass.GENERIC_CITY_OBJECT);
                return;
            }
            case 10: {
                this.desireCityObjects.add(CityGMLClass.CITY_OBJECT_GROUP);
                return;
            }
            case 11: {
                this.desireCityObjects.add(CityGMLClass.TUNNEL);
                return;
            }
            case 12: {
                this.desireCityObjects.add(CityGMLClass.BRIDGE);
                return;
            }
        }
    }

    public String getCityObjectName(CityGMLClass cityGMLClass) {
        if (CityGMLClass.BUILDING == cityGMLClass) {
            return this.getName(2);
        }
        if (CityGMLClass.CITY_FURNITURE == cityGMLClass) {
            return this.getName(8);
        }
        if (CityGMLClass.LAND_USE == cityGMLClass) {
            return this.getName(4);
        }
        if (CityGMLClass.CITY_OBJECT_GROUP == cityGMLClass) {
            return this.getName(10);
        }
        if (CityGMLClass.GENERIC_CITY_OBJECT == cityGMLClass) {
            return this.getName(9);
        }
        if (CityGMLClass.RELIEF_FEATURE == cityGMLClass) {
            return this.getName(7);
        }
        if (CityGMLClass.TRANSPORTATION_COMPLEX == cityGMLClass || cityGMLClass == CityGMLClass.ROAD || cityGMLClass == CityGMLClass.RAILWAY || cityGMLClass == CityGMLClass.TRACK || cityGMLClass == CityGMLClass.SQUARE) {
            return this.getName(6);
        }
        if (CityGMLClass.PLANT_COVER == cityGMLClass || cityGMLClass == CityGMLClass.SOLITARY_VEGETATION_OBJECT) {
            return this.getName(5);
        }
        if (CityGMLClass.WATER_BODY == cityGMLClass) {
            return this.getName(3);
        }
        if (CityGMLClass.TUNNEL == cityGMLClass) {
            return this.getName(11);
        }
        if (CityGMLClass.BRIDGE == cityGMLClass) {
            return this.getName(12);
        }
        return "";
    }
}

