/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.citydb.log.Logger;
import org.citydb.modules.common.balloon.BalloonTemplateHandlerImpl;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.CSVColumns;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.SeparatorPhrase;
import org.citydb.plugins.spreadsheet_gen.gui.view.components.NewCSVColumnDialog;

public class Translator {
    private StringBuffer wordparser = new StringBuffer();
    private int offset;
    private Set<String> keys;
    private Set<String> aggregations;
    private HashMap<String, Set<String>> _3dcitydbcontent;
    private ArrayList<String> columnTitle;
    private static Translator INSTANCE = new Translator();
    private Map<String, String> templateMap;
    private final Logger LOG = Logger.getInstance();

    public Translator() {
        BalloonTemplateHandlerImpl balloonTemplateHandlerImpl = new BalloonTemplateHandlerImpl("", null);
        this.aggregations = balloonTemplateHandlerImpl.getSupportedAggregationFunctions();
        this._3dcitydbcontent = balloonTemplateHandlerImpl.getSupportedTablesAndColumns();
        this.keys = this._3dcitydbcontent.keySet();
    }

    public static Translator getInstance() {
        return INSTANCE;
    }

    public Map<String, String> getTemplateHashmap() {
        return this.templateMap;
    }

    public String translateToBalloonTemplate(File file) throws Exception {
        String string;
        this.templateMap = new HashMap<String, String>();
        String string2 = SeparatorPhrase.getInstance().getTempPhrase();
        this.columnTitle = new ArrayList();
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<3DCityDB>CITYOBJECT/GMLID</3DCityDB>");
        this.columnTitle.add("GMLID");
        this.templateMap.put("GMLID", "CITYOBJECT__GMLID");
        while ((string = bufferedReader.readLine()) != null) {
            String string3;
            String string4;
            if (!string.startsWith("//") && !string.startsWith(";") && string.indexOf(58) > 0) {
                string4 = string.substring(0, string.indexOf(58));
                string3 = this.translateLine(string.substring(string.indexOf(58) + 1, string.length()), false);
                String string5 = string4;
                String string6 = null;
                try {
                    string6 = this.getTableColumn(string.substring(string.indexOf(58) + 1, string.length()));
                }
                catch (Exception exception) {
                    this.LOG.error(exception.getMessage());
                }
                this.templateMap.put(string5.trim(), string6);
            } else {
                string3 = this.translateLine(string, true);
                string4 = null;
            }
            if (string3 == null || string3.length() <= 0) continue;
            stringBuffer.append(string2);
            stringBuffer.append(string3);
            if (string4 == null) continue;
            this.columnTitle.add(string4);
        }
        return stringBuffer.toString();
    }

    public String translateToBalloonTemplate(ArrayList<CSVColumns> arrayList) throws IOException {
        this.templateMap = new HashMap<String, String>();
        String string = SeparatorPhrase.getInstance().getTempPhrase();
        this.columnTitle = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<3DCityDB>CITYOBJECT/GMLID</3DCityDB>");
        this.columnTitle.add("GMLID");
        this.templateMap.put("GMLID", "CITYOBJECT__GMLID");
        for (CSVColumns cSVColumns : arrayList) {
            String string2 = cSVColumns.title;
            String string3 = this.translateLine(cSVColumns.textcontent, false);
            String string4 = string2;
            String string5 = null;
            try {
                string5 = this.getTableColumn(cSVColumns.textcontent);
            }
            catch (Exception exception) {
                this.LOG.error(exception.getMessage());
            }
            this.templateMap.put(string4.trim(), string5);
            if (string3 == null || string3.length() <= 0) continue;
            stringBuffer.append(string);
            stringBuffer.append(string3);
            this.columnTitle.add(string2);
        }
        return stringBuffer.toString();
    }

    public String getProperHeader(String string) {
        this.columnTitle = new ArrayList();
        this.translateLine(string, true);
        return this.columnTitle.get(0);
    }

    public ArrayList<String> getColumnTitle() {
        return this.columnTitle;
    }

    public StyledDocument getFormatedDocument(String string) {
        StyleContext styleContext = new StyleContext();
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument(styleContext);
        try {
            String string2 = this.translateLine(string, false);
            int n = 0;
            int n2 = 0;
            while (string2.indexOf("<3DCityDB>", n) != -1) {
                n2 = string2.indexOf("<3DCityDB>", n);
                if (n2 != n) {
                    defaultStyledDocument.insertString(defaultStyledDocument.getLength(), string2.substring(n, n2), NewCSVColumnDialog.getDefaultStyle());
                    n = n2;
                }
                n2 = string2.indexOf("</3DCityDB>", n += "<3DCityDB>".length());
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), string2.substring(n, n2), NewCSVColumnDialog.getLabelStyle());
                n = n2 + "</3DCityDB>".length();
            }
            if (n != string2.length() - 1) {
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), string2.substring(n, string2.length()), NewCSVColumnDialog.getDefaultStyle());
            }
            n = 0;
            n2 = 0;
            string2 = defaultStyledDocument.getText(0, defaultStyledDocument.getLength());
            String string3 = System.getProperty("line.separator");
            while (string2.indexOf(string3, n) != -1) {
                n2 = string2.indexOf(string3, n);
                defaultStyledDocument.remove(n2, string3.length());
                defaultStyledDocument.insertString(n2, "[EOL]", NewCSVColumnDialog.getEOLStyle());
                n = n2 + "[EOL]".length();
                string2 = defaultStyledDocument.getText(0, defaultStyledDocument.getLength());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultStyledDocument;
    }

    private String translateLine(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        this.offset = 0;
        String string2 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        String string3 = "";
        boolean bl10 = true;
        String string4 = "";
        int n = 0;
        int n2 = 0;
        String string5 = "";
        string = string.replace("[EOL]", System.getProperty("line.separator"));
        char[] cArray = string.toCharArray();
        while (this.offset < string.length() || !bl9) {
            String string6;
            if (bl9) {
                string2 = this.getWord(cArray);
            }
            bl9 = true;
            if (string2.equals("//") || string2.equals(";")) {
                return stringBuffer.toString();
            }
            if (!bl2 && ((bl7 = this._3dcitydbcontent.containsKey(string2)) || this.offset < cArray.length && cArray[this.offset] == '/')) {
                if (!bl7) {
                    string3 = null;
                    string6 = string2.toUpperCase();
                    for (String string7 : this.keys) {
                        if (!string6.contains(string7)) continue;
                        string3 = string7;
                        break;
                    }
                    if (string3 != null) {
                        bl10 = false;
                        bl2 = true;
                        n = stringBuffer.length() + string6.indexOf(string3);
                        string4 = string3;
                        stringBuffer.append(string2);
                        string5 = string3;
                        continue;
                    }
                } else {
                    bl10 = false;
                    bl2 = true;
                    n = stringBuffer.length();
                    string4 = string2;
                    stringBuffer.append(string2);
                    string5 = string2;
                    continue;
                }
            }
            if (bl2 && !bl3 && string2.equals("/")) {
                if (bl10) {
                    bl2 = false;
                } else {
                    bl10 = false;
                    bl3 = true;
                    stringBuffer.append(string2);
                    continue;
                }
            }
            if (bl2 && bl3 && !bl5 && this.aggregations.contains(string2)) {
                if (bl10) {
                    bl2 = false;
                    bl3 = false;
                } else {
                    bl10 = false;
                    bl5 = true;
                    stringBuffer.append(string2);
                    continue;
                }
            }
            if (bl2 && bl3 && !bl4 && this._3dcitydbcontent.containsKey(string5)) {
                if (bl10) {
                    bl2 = false;
                    bl3 = false;
                    bl5 = false;
                } else {
                    if (this._3dcitydbcontent.get(string5).contains(string2)) {
                        bl10 = false;
                        bl4 = true;
                        bl8 = true;
                        stringBuffer.append(string2);
                        string4 = string4 + "_" + string2;
                        n2 = stringBuffer.length();
                        continue;
                    }
                    Set<String> set = this._3dcitydbcontent.get(string5);
                    string6 = string2.toUpperCase();
                    string3 = null;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string8 = (String)iterator.next();
                        if (!string6.startsWith(string8)) continue;
                        string3 = string8;
                        break;
                    }
                    if (string3 != null) {
                        bl10 = false;
                        bl4 = true;
                        bl8 = false;
                        stringBuffer.append(string3);
                        n2 = stringBuffer.length();
                        string4 = string4 + "_" + string3;
                        this.offset -= string2.length() - string3.length();
                        continue;
                    }
                }
            }
            if (bl2 && bl4 && !bl10 && string2.equals("[")) {
                stringBuffer.append(string2);
                bl6 = true;
                continue;
            }
            if (bl2 && bl4 && bl8 && bl6 && string2.equals("]")) {
                stringBuffer.append(string2);
                n2 = stringBuffer.length();
                bl2 = false;
                bl4 = false;
                bl3 = false;
                bl5 = false;
                bl6 = false;
                bl8 = false;
                stringBuffer.insert(n2, "</3DCityDB>");
                stringBuffer.insert(n, "<3DCityDB>");
                continue;
            }
            if (string2.equals("]") || string2.equals("[")) {
                stringBuffer.append(string2);
                continue;
            }
            if (bl2 && bl3 && bl4 && !bl6) {
                bl2 = false;
                bl4 = false;
                bl3 = false;
                bl5 = false;
                bl6 = false;
                bl8 = false;
                stringBuffer.insert(n2, "</3DCityDB>");
                stringBuffer.insert(n, "<3DCityDB>");
                bl9 = false;
                continue;
            }
            bl10 = true;
            stringBuffer.append(string2);
        }
        if (bl2 && bl3 && bl4) {
            stringBuffer.insert(n2, "</3DCityDB>");
            stringBuffer.insert(n, "<3DCityDB>");
        }
        if (bl) {
            this.columnTitle.add(string4);
        }
        return stringBuffer.toString();
    }

    private String getWord(char[] cArray) {
        this.wordparser.setLength(0);
        if (Character.isLetterOrDigit(cArray[this.offset])) {
            while (cArray.length > this.offset && (Character.isLetterOrDigit(cArray[this.offset]) || cArray[this.offset] == '_')) {
                this.wordparser.append(cArray[this.offset]);
                ++this.offset;
            }
            return this.wordparser.toString();
        }
        if (Character.isWhitespace(cArray[this.offset])) {
            while (cArray.length > this.offset && Character.isWhitespace(cArray[this.offset])) {
                this.wordparser.append(cArray[this.offset]);
                ++this.offset;
            }
            return this.wordparser.toString();
        }
        if (Character.isDefined(cArray[this.offset])) {
            this.wordparser.append(cArray[this.offset]);
            ++this.offset;
            if (cArray.length > this.offset && cArray[this.offset] == '/') {
                this.wordparser.append(cArray[this.offset]);
                ++this.offset;
            }
            return this.wordparser.toString();
        }
        return this.wordparser.toString();
    }

    public String getTableColumn(String string) throws Exception {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = string.indexOf(47);
        string3 = string.substring(0, n).trim();
        if (string.charAt(++n) == '[') {
            string2 = string.substring(++n, string.indexOf(93, n)).trim();
            n = string.indexOf(93, n) + 1;
        }
        if (string.indexOf(91, n) == -1) {
            string4 = string.substring(n).trim();
            if (string4.indexOf(" ") != -1) {
                String[] stringArray = string4.split(" ");
                string4 = stringArray[0];
                string5 = stringArray[1];
            }
        } else {
            string4 = string.substring(n, string.indexOf(91, n)).trim();
            n = string.indexOf(93);
            if (++n < string.length() && string.substring(n).trim().length() > 0) {
                string5 = string.substring(n).trim();
            }
        }
        if (string2 != null && (string2.equalsIgnoreCase("MAX") || string2.equalsIgnoreCase("MIN") || string2.equalsIgnoreCase("AVG") || string2.equalsIgnoreCase("SUM") || string2.equalsIgnoreCase("COUNT"))) {
            return "NUMBER_COLUMN_KEY";
        }
        if (string.indexOf("[EOL]") > -1) {
            return "STRING_COLUMN_KEY";
        }
        if (string5 != null) {
            return "STRING_COLUMN_KEY";
        }
        return string3 + "__" + string4;
    }
}

