/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.citydb.api.concurrent.WorkerPool;
import org.citydb.api.database.DatabaseSrs;
import org.citydb.api.database.DatabaseType;
import org.citydb.api.geometry.BoundingBox;
import org.citydb.api.geometry.GeometryObject;
import org.citydb.database.DatabaseConnectionPool;
import org.citydb.database.adapter.AbstractDatabaseAdapter;
import org.citydb.log.Logger;
import org.citydb.modules.kml.database.Queries;
import org.citydb.plugins.spreadsheet_gen.concurrent.work.CityObjectWork;
import org.citydb.plugins.spreadsheet_gen.config.ConfigImpl;
import org.citydb.util.Util;
import org.citygml4j.geometry.Point;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.gml.geometry.primitives.DirectPosition;
import org.citygml4j.model.gml.geometry.primitives.Envelope;

public class DBManager {
    private final Logger LOG = Logger.getInstance();
    private final WorkerPool<CityObjectWork> workerpool;
    private ConfigImpl config;
    private volatile boolean shouldRun = true;
    private AtomicBoolean isInterrupted = new AtomicBoolean(false);
    private Connection connection;
    private AbstractDatabaseAdapter databaseAdapter;
    private DatabaseSrs dbSrs;
    private DatabaseConnectionPool dbConnectionPool;

    public DBManager(DatabaseConnectionPool databaseConnectionPool, ConfigImpl configImpl, WorkerPool<CityObjectWork> workerPool) throws SQLException {
        this.dbConnectionPool = databaseConnectionPool;
        this.config = configImpl;
        this.workerpool = workerPool;
        this.init();
    }

    public void init() throws SQLException {
        this.databaseAdapter = this.dbConnectionPool.getActiveDatabaseAdapter();
        this.connection = this.dbConnectionPool.getConnection();
        this.dbSrs = this.databaseAdapter.getConnectionMetaData().getReferenceSystem();
        if (this.dbConnectionPool.getActiveDatabaseAdapter().hasVersioningSupport()) {
            this.dbConnectionPool.getActiveDatabaseAdapter().getWorkspaceManager().gotoWorkspace(this.connection, this.config.getWorkspace());
        }
    }

    public void queryObjects(HashSet<CityGMLClass> hashSet) throws SQLException {
        BoundingBox boundingBox = this.config.getBoundingbox();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        HashMap<CityGMLClass, AtomicInteger> hashMap = new HashMap<CityGMLClass, AtomicInteger>();
        for (CityGMLClass cityGMLClass : hashSet) {
            hashMap.put(cityGMLClass, new AtomicInteger(0));
        }
        if (boundingBox.getSrs().isSupported() && boundingBox.getSrs().getSrid() != this.dbSrs.getSrid()) {
            try {
                boundingBox = this.databaseAdapter.getUtil().transformBoundingBox(boundingBox, boundingBox.getSrs(), this.dbSrs);
            }
            catch (SQLException sQLException) {
                this.LOG.error("Failed to initialize bounding box filter.");
            }
        }
        try {
            preparedStatement = this.connection.prepareStatement(Queries.GET_IDS((DatabaseType)this.databaseAdapter.getDatabaseType()));
            preparedStatement.setObject(1, this.databaseAdapter.getGeometryConverter().getDatabaseObject(GeometryObject.createEnvelope((BoundingBox)boundingBox), this.connection));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next() && this.shouldRun) {
                Object object;
                String string = resultSet.getString("gmlId");
                int n = resultSet.getInt("objectclass_id");
                GeometryObject geometryObject = null;
                Object object2 = resultSet.getObject("envelope");
                if (!resultSet.wasNull() && object2 != null) {
                    geometryObject = this.databaseAdapter.getGeometryConverter().getEnvelope(object2);
                }
                if (geometryObject != null && geometryObject.getGeometryType() == GeometryObject.GeometryType.ENVELOPE) {
                    object = geometryObject.getCoordinates(0);
                    Envelope envelope = new Envelope();
                    envelope.setLowerCorner(new Point(object[0], object[1], 0.0));
                    envelope.setUpperCorner(new Point(object[3], object[4], 0.0));
                    if (this.filter(envelope, boundingBox)) continue;
                }
                if (!hashSet.contains(Util.classId2cityObject((int)n))) continue;
                ((AtomicInteger)hashMap.get(Util.classId2cityObject((int)n))).incrementAndGet();
                object = new CityObjectWork(string, n);
                this.workerpool.addWork(object);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (preparedStatement != null) {
                preparedStatement.close();
                preparedStatement = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startQuery(HashSet<CityGMLClass> hashSet) throws SQLException {
        try {
            this.queryObjects(hashSet);
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {}
                this.connection = null;
            }
        }
    }

    private boolean filter(Envelope envelope, BoundingBox boundingBox) {
        if (!envelope.isSetLowerCorner() || !envelope.isSetUpperCorner()) {
            return true;
        }
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        if (!directPosition.isSetValue() || !directPosition2.isSetValue()) {
            return true;
        }
        List list = directPosition.getValue();
        List list2 = directPosition2.getValue();
        if (list.size() < 2 || list2.size() < 2) {
            return true;
        }
        Double d = (Double)list.get(0);
        Double d2 = (Double)list.get(1);
        Double d3 = (Double)list2.get(0);
        Double d4 = (Double)list2.get(1);
        double d5 = d + (d3 - d) / 2.0;
        double d6 = d2 + (d4 - d2) / 2.0;
        return !(d5 >= boundingBox.getLowerLeftCorner().getX()) || !(d6 > boundingBox.getLowerLeftCorner().getY()) || !(d5 < boundingBox.getUpperRightCorner().getX()) || !(d6 <= boundingBox.getUpperRightCorner().getY());
    }

    public void shutdown() {
        if (this.isInterrupted.compareAndSet(false, true)) {
            this.shouldRun = false;
        }
    }
}

