/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.gui;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.citydb.api.event.Event;
import org.citydb.api.event.EventDispatcher;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.gui.Users;
import org.citydb.plugins.spreadsheet_gen.events.SharingEvent;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class SharingListTableDataModel
extends AbstractTableModel {
    public static final int delColumnNumber = 2;
    private String[] columnNames;
    private ArrayList<Users> rows = new ArrayList();
    ImageIcon delIcon;
    ImageIcon blankIcon;
    final EventDispatcher eventDispatcher;

    SharingListTableDataModel() {
        this.columnNames = new String[3];
        this.columnNames[0] = Util.I18N.getString("spshg.sharing.column.email");
        this.columnNames[1] = Util.I18N.getString("spshg.sharing.column.permission");
        this.columnNames[2] = "";
        URL uRL = this.getClass().getResource("img/delete.png");
        if (uRL != null) {
            this.delIcon = new ImageIcon(uRL, "delete");
        }
        BufferedImage bufferedImage = new BufferedImage(12, 12, 2);
        this.blankIcon = new ImageIcon(bufferedImage);
        this.eventDispatcher = ObjectRegistry.getInstance().getEventDispatcher();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
            case 2: {
                return ImageIcon.class;
            }
        }
        return super.getColumnClass(n);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 2 && this.rows.get(n).isOwner()) {
            return this.blankIcon;
        }
        if (n2 == 2) {
            return this.delIcon;
        }
        return this.rows.get(n).getValue(n2);
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n].toString();
    }

    public void addNewRow(Users users) {
        this.rows.add(users);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 2 || n2 == 0) {
            return false;
        }
        return !this.rows.get(n).isOwner();
    }

    public void removeRow(int n) {
        if (n >= this.rows.size() || n < 0) {
            return;
        }
        this.rows.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void removeUser(Users users) {
        this.rows.remove(users);
        this.fireTableRowsDeleted(0, this.rows.size());
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                this.rows.get(n).setEmail((String)object);
                break;
            }
            case 1: {
                this.rows.get(n).setPermissionType((String)object);
                this.eventDispatcher.triggerEvent((Event)new SharingEvent(5, this, this.rows.get(n)));
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public Users getRow(int n) {
        if (n >= this.rows.size() || n < 0) {
            return null;
        }
        return this.rows.get(n);
    }
}

