/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.citydb.api.controller.ViewController;
import org.citydb.api.event.Event;
import org.citydb.api.event.EventDispatcher;
import org.citydb.api.event.EventHandler;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.CloudServiceRegistery;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.GoogleSpreadSheetService;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.ShareSettingController;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.gui.SharingListTableDataModel;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.gui.TableSelectionListener;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.gui.Users;
import org.citydb.plugins.spreadsheet_gen.events.EventType;
import org.citydb.plugins.spreadsheet_gen.events.SharingEvent;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class ShareSettingDialog
extends JDialog
implements EventHandler {
    protected static final int BORDER_THICKNESS = 5;
    protected static final int MAX_TEXTFIELD_HEIGHT = 20;
    protected static final int MAX_LABEL_WIDTH = 60;
    private static final int PREFERRED_WIDTH = 400;
    private static final int PREFERRED_HEIGHT = 410;
    private final ViewController viewController;
    private JComboBox accessSettings = new JComboBox();
    private SharingListTableDataModel tableDataModel = new SharingListTableDataModel();
    private JTable table;
    private JScrollPane scrollPane;
    private JTextArea emailText = new JTextArea();
    private JComboBox scopeComboBox;
    private JButton addNewPersonButton = new JButton("");
    private JProgressBar progressBar;
    private JButton okButton = new JButton("");
    final GoogleSpreadSheetService gsss;
    private Users currentUser;
    final EventDispatcher eventDispatcher = ObjectRegistry.getInstance().getEventDispatcher();
    public int selectedScopeIndex = 0;
    ActionListener ac;

    public ShareSettingDialog(JFrame jFrame) {
        super(jFrame, Util.I18N.getString("spshg.dialog.sharesettings.dialogtitle"), true);
        this.eventDispatcher.addEventHandler((Enum)EventType.SHARING_EVENT, (EventHandler)this);
        this.viewController = ObjectRegistry.getInstance().getViewController();
        this.gsss = (GoogleSpreadSheetService)CloudServiceRegistery.getInstance().getSelectedService();
        this.init();
    }

    private void init() {
        this.setSize(new Dimension(400, 410));
        Box box = Box.createVerticalBox();
        JLabel jLabel = new JLabel(Util.I18N.getString("spshg.dialog.sharesettings.whohasaccess"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        this.initializeScopeComboBox();
        this.table = new JTable(this.tableDataModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 164));
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(3);
        TableColumn tableColumn = null;
        this.table.setRowHeight(25);
        this.table.setSelectionMode(0);
        tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(50);
        tableColumn.setCellEditor(new DefaultCellEditor(Users.getPermissionComboBox()));
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(150);
        this.scrollPane = new JScrollPane(this.table);
        this.table.setCellSelectionEnabled(true);
        this.table.getSelectionModel().addListSelectionListener(new TableSelectionListener(this));
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(new TableSelectionListener(this));
        this.table.setShowVerticalLines(false);
        JLabel jLabel2 = new JLabel(Util.I18N.getString("spshg.dialog.sharesettings.addpeople"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel2, "West");
        this.scopeComboBox = Users.getPermissionComboBox();
        this.addNewPersonButton.setText(Util.I18N.getString("spshg.dialog.sharesettings.addperson"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        this.emailText.setLineWrap(true);
        this.emailText.setWrapStyleWord(true);
        this.emailText.setRows(2);
        jPanel3.add((Component)new JScrollPane(this.emailText), Util.setConstraints(0, 0, 1.0, 1.0, 1, 5, 0, 5, 5));
        jPanel3.add((Component)this.scopeComboBox, Util.setConstraints(19, 1, 0, 0.0, 0.0, 0, 5, 5, 5, 5));
        jPanel3.add((Component)this.addNewPersonButton, Util.setConstraints(19, 2, 0, 0.0, 0.0, 0, 3, 5, 5, 0));
        this.emailTextFieldLostFocus();
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        this.okButton.setText(Util.I18N.getString("spshg.dialog.sharesettings.ok"));
        this.okButton.setPreferredSize(this.addNewPersonButton.getMinimumSize());
        jPanel4.add(this.okButton);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(jPanel);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(this.accessSettings);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(this.scrollPane);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box.add(jPanel2);
        box.add(jPanel3);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box.add(this.progressBar);
        this.setLayout(new BorderLayout());
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)box, "North");
        this.add((Component)jPanel4, "South");
        this.viewController.getComponentFactory().createPopupMenuDecorator().decorate(new JTextComponent[]{this.emailText});
        this.addListeners();
        this.loadPermissionList();
    }

    private void addListeners() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ShareSettingDialog.this.eventDispatcher.removeEventHandler((EventHandler)ShareSettingDialog.this);
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShareSettingDialog.this.dispose();
            }
        });
        this.addNewPersonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ShareSettingDialog.this.emailText.getText().trim();
                if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase(Util.I18N.getString("spshg.dialog.sharesettings.message"))) {
                    return;
                }
                String[] stringArray = string.split("\\,");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || stringArray[i].trim().length() == 0) continue;
                    ShareSettingDialog.this.addNewPersonButton.setEnabled(false);
                    ShareSettingDialog.this.okButton.setEnabled(false);
                    ShareSettingDialog.this.currentUser = new Users(null, stringArray[i], (String)ShareSettingDialog.this.scopeComboBox.getSelectedItem(), 10);
                    ShareSettingDialog.this.showProcessGUI(true);
                    ShareSettingController shareSettingController = new ShareSettingController(ShareSettingDialog.this.gsss);
                    shareSettingController.addNewACLENtry(ShareSettingDialog.this.currentUser);
                    Thread thread = new Thread(shareSettingController);
                    thread.start();
                }
            }
        });
        this.ac = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedIndex() != ShareSettingDialog.this.selectedScopeIndex) {
                    ShareSettingDialog.this.showProcessGUI(true);
                    ShareSettingDialog.this.selectedScopeIndex = jComboBox.getSelectedIndex();
                    Users users = ShareSettingDialog.this.getScopeComboBoxState(jComboBox.getSelectedIndex());
                    ShareSettingController shareSettingController = new ShareSettingController(ShareSettingDialog.this.gsss);
                    shareSettingController.updatePermission(users);
                    Thread thread = new Thread(shareSettingController);
                    thread.start();
                }
            }
        };
        this.accessSettings.addActionListener(this.ac);
        this.emailText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (ShareSettingDialog.this.emailText.getText().trim().length() == 0) {
                    ShareSettingDialog.this.emailTextFieldLostFocus();
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (ShareSettingDialog.this.emailText.getText().equalsIgnoreCase(Util.I18N.getString("spshg.dialog.sharesettings.message"))) {
                    ShareSettingDialog.this.emailText.setText("");
                    ShareSettingDialog.this.emailText.setForeground(Color.black);
                }
            }
        });
    }

    private void emailTextFieldLostFocus() {
        this.emailText.setText(Util.I18N.getString("spshg.dialog.sharesettings.message"));
        this.emailText.setForeground(Color.gray);
    }

    private void loadPermissionList() {
        this.showProcessGUI(true);
        ShareSettingController shareSettingController = new ShareSettingController(this.gsss);
        shareSettingController.loadInitialState();
        Thread thread = new Thread(shareSettingController);
        thread.start();
    }

    public void actionPerformedTableSelection() {
        int n;
        Users users;
        if (this.table.getSelectedColumn() == 2 && (users = this.tableDataModel.getRow(n = this.table.getSelectedRow())) != null && !users.isOwner()) {
            this.showProcessGUI(true);
            ShareSettingController shareSettingController = new ShareSettingController(this.gsss);
            shareSettingController.removeACLEntrl(users);
            Thread thread = new Thread(shareSettingController);
            thread.start();
        }
    }

    private void initializeScopeComboBox() {
        this.accessSettings.addItem(Util.I18N.getString("spshg.dialog.sharesettings.access.private"));
        this.accessSettings.addItem(Util.I18N.getString("spshg.dialog.sharesettings.access.link.view"));
        this.accessSettings.addItem(Util.I18N.getString("spshg.dialog.sharesettings.access.link.edit"));
        this.accessSettings.addItem(Util.I18N.getString("spshg.dialog.sharesettings.access.public.view"));
        this.accessSettings.addItem(Util.I18N.getString("spshg.dialog.sharesettings.access.public.edit"));
        this.selectedScopeIndex = 0;
        this.accessSettings.removeActionListener(this.ac);
        this.accessSettings.setSelectedIndex(this.selectedScopeIndex);
        this.accessSettings.addActionListener(this.ac);
    }

    private Users getScopeComboBoxState(int n) {
        int n2;
        int n3;
        switch (n) {
            case 0: {
                n3 = 3;
                n2 = 15;
                break;
            }
            case 1: {
                n3 = 3;
                n2 = 14;
                break;
            }
            case 2: {
                n3 = 2;
                n2 = 14;
                break;
            }
            case 3: {
                n3 = 3;
                n2 = 13;
                break;
            }
            case 4: {
                n3 = 2;
                n2 = 13;
                break;
            }
            default: {
                n3 = 3;
                n2 = 15;
            }
        }
        return new Users(null, null, n3, n2);
    }

    private void setScopeComboBox(Users users) {
        if (users.getScope() == 13) {
            if (users.getPermissionType() == 3) {
                this.accessSettings.removeActionListener(this.ac);
                this.accessSettings.setSelectedItem(Util.I18N.getString("spshg.dialog.sharesettings.access.public.view"));
                this.selectedScopeIndex = this.accessSettings.getSelectedIndex();
                this.accessSettings.addActionListener(this.ac);
                return;
            }
            if (users.getPermissionType() == 2) {
                this.accessSettings.removeActionListener(this.ac);
                this.accessSettings.setSelectedItem(Util.I18N.getString("spshg.dialog.sharesettings.access.public.edit"));
                this.selectedScopeIndex = this.accessSettings.getSelectedIndex();
                this.accessSettings.addActionListener(this.ac);
                return;
            }
        }
        if (users.getScope() == 14) {
            if (users.getPermissionType() == 3) {
                this.accessSettings.removeActionListener(this.ac);
                this.accessSettings.setSelectedItem(Util.I18N.getString("spshg.dialog.sharesettings.access.link.view"));
                this.selectedScopeIndex = this.accessSettings.getSelectedIndex();
                this.accessSettings.addActionListener(this.ac);
                return;
            }
            if (users.getPermissionType() == 2) {
                this.accessSettings.removeActionListener(this.ac);
                this.accessSettings.setSelectedItem(Util.I18N.getString("spshg.dialog.sharesettings.access.link.edit"));
                this.selectedScopeIndex = this.accessSettings.getSelectedIndex();
                this.accessSettings.addActionListener(this.ac);
                return;
            }
        }
        if (users.getScope() == 15) {
            this.accessSettings.removeActionListener(this.ac);
            this.accessSettings.setSelectedItem(Util.I18N.getString("spshg.dialog.sharesettings.access.private"));
            this.selectedScopeIndex = this.accessSettings.getSelectedIndex();
            this.accessSettings.addActionListener(this.ac);
            return;
        }
    }

    public void handleEvent(Event event) throws Exception {
        if (event.getEventType() == EventType.SHARING_EVENT) {
            final SharingEvent sharingEvent = (SharingEvent)event;
            switch (sharingEvent.getType()) {
                case 1: {
                    this.showProcessGUI(false);
                    this.emailTextFieldLostFocus();
                    this.addNewPersonButton.setEnabled(true);
                    this.okButton.setEnabled(true);
                    this.tableDataModel.addNewRow(sharingEvent.getUser());
                    return;
                }
                case 4: {
                    this.showProcessGUI(false);
                    if (sharingEvent.getUser().getScope() == 13 || sharingEvent.getUser().getScope() == 14) {
                        this.setScopeComboBox(sharingEvent.getUser());
                    } else {
                        this.tableDataModel.addNewRow(sharingEvent.getUser());
                    }
                    return;
                }
                case 6: {
                    this.showProcessGUI(false);
                    return;
                }
                case 2: {
                    this.showProcessGUI(false);
                    if (sharingEvent.getUser().getEmail() == null) {
                        this.setScopeComboBox(sharingEvent.getUser());
                    }
                    return;
                }
                case 3: {
                    this.showProcessGUI(false);
                    this.table.getSelectionModel().clearSelection();
                    this.tableDataModel.removeUser(sharingEvent.getUser());
                    return;
                }
                case 7: {
                    this.showProcessGUI(false);
                    this.emailTextFieldLostFocus();
                    this.addNewPersonButton.setEnabled(true);
                    this.okButton.setEnabled(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(ShareSettingDialog.this, sharingEvent.getMessage(), sharingEvent.getMessageTitle(), 0);
                        }
                    });
                    return;
                }
                case 5: {
                    this.showProcessGUI(true);
                    ShareSettingController shareSettingController = new ShareSettingController(this.gsss);
                    shareSettingController.updatePermission(sharingEvent.getUser());
                    Thread thread = new Thread(shareSettingController);
                    thread.start();
                    return;
                }
            }
        }
    }

    private void showProcessGUI(boolean bl) {
        this.progressBar.setIndeterminate(bl);
        this.progressBar.setVisible(bl);
    }
}

