/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.docs.DocumentListEntry;
import com.google.gdata.data.extensions.LastModifiedBy;
import java.util.TimeZone;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class Spreadsheet {
    public static final int NEW = 0;
    public static final int OVERWRITE = 1;
    String name;
    String resourceId;
    String link;
    String updatedBy;
    String lastUpdate;
    int type;
    DocumentListEntry entry;

    Spreadsheet(DocumentListEntry documentListEntry) {
        this.type = 1;
        this.setEntry(documentListEntry);
    }

    Spreadsheet() {
        this.type = 0;
    }

    public void setEntry(DocumentListEntry documentListEntry) {
        this.name = documentListEntry.getTitle().getPlainText();
        this.resourceId = documentListEntry.getResourceId();
        this.link = documentListEntry.getDocumentLink().getHref();
        LastModifiedBy lastModifiedBy = documentListEntry.getLastModifiedBy();
        this.updatedBy = lastModifiedBy.getName() + " - " + lastModifiedBy.getEmail();
        DateTime dateTime = documentListEntry.getUpdated();
        dateTime.setTzShift(Integer.valueOf(TimeZone.getDefault().getRawOffset() / 60000));
        this.lastUpdate = dateTime.toUiString();
        this.entry = documentListEntry;
    }

    public String getInfo() {
        return String.format(Util.I18N.getString("spshg.message.overwrite.on"), this.name, this.updatedBy, this.lastUpdate);
    }

    public String toString() {
        if (this.type == 1) {
            return this.getInfo();
        }
        return Util.I18N.getString("spshg.message.overwrite.new");
    }

    public int getType() {
        return this.type;
    }

    public DocumentListEntry getEntry() {
        return this.entry;
    }
}

