/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl;

import com.google.gdata.data.acl.AclEntry;
import com.google.gdata.util.VersionConflictException;
import java.util.ArrayList;
import java.util.List;
import org.citydb.api.event.Event;
import org.citydb.api.event.EventDispatcher;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.GoogleSpreadSheetService;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.gui.Users;
import org.citydb.plugins.spreadsheet_gen.events.SharingEvent;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class ShareSettingController
implements Runnable {
    public static final int TASK_ADD_NEW = 1;
    public static final int TASK_UPDATE_PERMISSION = 2;
    public static final int TASK_REMOVE = 3;
    public static final int TASK_LOAD_CURRENT_STATE = 4;
    public static final int TASK_VALUE_CHANGED = 5;
    public static final int FINISH_UPDATE = 6;
    public static final int TASK_CANCELD = 7;
    public static volatile List<AclEntry> AclEnttyList = new ArrayList<AclEntry>();
    private int type = 0;
    private GoogleSpreadSheetService gsss = null;
    private Users user = null;
    private int scope;
    final EventDispatcher eventDispatcher;

    public ShareSettingController(GoogleSpreadSheetService googleSpreadSheetService) {
        this.gsss = googleSpreadSheetService;
        this.eventDispatcher = ObjectRegistry.getInstance().getEventDispatcher();
    }

    public void addNewACLENtry(Users users) {
        this.type = 1;
        this.user = users;
        this.scope = 10;
    }

    public void loadInitialState() {
        this.type = 4;
    }

    public void updatePermission(Users users) {
        this.user = users;
        this.type = 2;
    }

    public void removeACLEntrl(Users users) {
        this.user = users;
        this.type = 3;
    }

    @Override
    public void run() {
        block17: {
            try {
                switch (this.type) {
                    case 1: {
                        if (this.user == null) {
                            return;
                        }
                        AclEntry aclEntry = this.gsss.shareDocument(this.user.getPermissionType(), this.scope, this.user.getEmail());
                        AclEnttyList.add(aclEntry);
                        this.user.setName(aclEntry.getScope().getName());
                        this.eventDispatcher.triggerEvent((Event)new SharingEvent(1, this, this.user));
                        return;
                    }
                    case 4: {
                        AclEnttyList = this.gsss.updateAclList();
                        for (AclEntry aclEntry : AclEnttyList) {
                            Users users = aclEntry.getWithKey() != null ? new Users(null, null, GoogleSpreadSheetService.toLocalCode(aclEntry.getWithKey().getRole()), 14) : new Users(aclEntry.getScope().getName(), aclEntry.getScope().getValue(), GoogleSpreadSheetService.toLocalCode(aclEntry.getRole()), GoogleSpreadSheetService.toLocalCode(aclEntry.getScope().getType()));
                            this.eventDispatcher.triggerEvent((Event)new SharingEvent(4, this, users));
                        }
                        this.eventDispatcher.triggerEvent((Event)new SharingEvent(6, this, null));
                        return;
                    }
                    case 2: {
                        if (this.user == null) {
                            return;
                        }
                        if (this.user.isVisibilityDescription()) {
                            for (AclEntry aclEntry : AclEnttyList) {
                                if (aclEntry.getScope().getValue() != null) continue;
                                if (this.user.getScope() == 15) {
                                    AclEnttyList.remove(aclEntry);
                                    aclEntry.delete();
                                    this.eventDispatcher.triggerEvent((Event)new SharingEvent(2, this, this.user));
                                    return;
                                }
                                aclEntry.delete();
                                AclEntry aclEntry2 = this.gsss.updatePermission(null, this.user);
                                AclEnttyList.remove(aclEntry);
                                AclEnttyList.add(aclEntry2);
                                this.eventDispatcher.triggerEvent((Event)new SharingEvent(2, this, this.user));
                                return;
                            }
                            AclEntry aclEntry = this.gsss.updatePermission(null, this.user);
                            AclEnttyList.add(aclEntry);
                            this.eventDispatcher.triggerEvent((Event)new SharingEvent(2, this, this.user));
                            return;
                        }
                        for (AclEntry aclEntry : AclEnttyList) {
                            if (aclEntry.getScope().getValue() == null || !aclEntry.getScope().getValue().equalsIgnoreCase(this.user.getEmail())) continue;
                            AclEntry aclEntry3 = this.gsss.updatePermission(aclEntry, this.user);
                            AclEnttyList.remove(aclEntry);
                            AclEnttyList.add(aclEntry3);
                            this.eventDispatcher.triggerEvent((Event)new SharingEvent(2, this, this.user));
                            return;
                        }
                        return;
                    }
                    case 3: {
                        if (this.user == null) {
                            return;
                        }
                        for (AclEntry aclEntry : AclEnttyList) {
                            if (aclEntry.getScope().getValue() == null || !aclEntry.getScope().getValue().equalsIgnoreCase(this.user.getEmail())) continue;
                            aclEntry.delete();
                            AclEnttyList.remove(aclEntry);
                            this.eventDispatcher.triggerEvent((Event)new SharingEvent(3, this, this.user));
                            return;
                        }
                        return;
                    }
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof VersionConflictException)) break block17;
                this.eventDispatcher.triggerEvent((Event)new SharingEvent(7, this, Util.I18N.getString("spshg.message.export.sharesettings.email.exist"), exception.getLocalizedMessage()));
                return;
            }
        }
        this.eventDispatcher.triggerEvent((Event)new SharingEvent(7, this, this.user));
    }
}

