/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl;

import com.google.gdata.client.GoogleService;
import com.google.gdata.client.docs.DocsService;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.acl.AclEntry;
import com.google.gdata.data.acl.AclFeed;
import com.google.gdata.data.acl.AclRole;
import com.google.gdata.data.acl.AclScope;
import com.google.gdata.data.acl.AclWithKey;
import com.google.gdata.data.docs.DocumentListEntry;
import com.google.gdata.data.docs.DocumentListFeed;
import com.google.gdata.data.docs.RevisionEntry;
import com.google.gdata.data.docs.RevisionFeed;
import com.google.gdata.data.media.MediaFileSource;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.util.ServiceException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.AuthenticationException;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.CaptchaRequiredException;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.CloudService;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.UploadException;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.MyRunnable;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.Spreadsheet;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.gui.ShareSettingDialog;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice_impl.gui.Users;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class GoogleSpreadSheetService
implements CloudService {
    public static final int ROLE_OWNER = 1;
    public static final int ROLE_WRITER = 2;
    public static final int ROLE_READER = 3;
    public static final int SCOPE_USER = 10;
    public static final int SCOPE_GROUP = 11;
    public static final int SCOPE_DOMAIN = 12;
    public static final int SCOPE_DEFAULT = 13;
    public static final int SCOPE_DEFAULT_WITH_KEY = 14;
    public static final int SCOPE_PRIVATE = 15;
    private DocsService service;
    private DocumentListEntry mainEntry = null;
    public static boolean useCorrectProxy = true;

    private DocsService getService() {
        if (this.service == null) {
            this.service = new DocsService("3dcitydb-spreadsheetplugin-v1.0");
        }
        return this.service;
    }

    @Override
    public synchronized String uploadFile(String string, String string2) throws Exception {
        Object object;
        Spreadsheet spreadsheet = null;
        ArrayList<Spreadsheet> arrayList = this.getSpreadsheetWithSameName(string2);
        if (arrayList.size() != 0) {
            object = new MyRunnable(arrayList);
            SwingUtilities.invokeAndWait((Runnable)object);
            spreadsheet = ((MyRunnable)object).getSelectedOne();
            if (spreadsheet == null) {
                throw new Exception(Util.I18N.getString("spshg.message.upload.cancel.user"));
            }
        }
        object = arrayList.size() == 0 || spreadsheet.getType() == 0 ? this.createNewFile(string, string2) : this.overrideOnFile(string, spreadsheet);
        return object;
    }

    private String createNewFile(String string, String string2) throws Exception {
        DocumentListEntry documentListEntry;
        File file = new File(string);
        DocumentListEntry documentListEntry2 = new DocumentListEntry();
        String string3 = DocumentListEntry.MediaType.fromFileName((String)file.getName()).getMimeType();
        documentListEntry2.setFile(file, string3);
        documentListEntry2.setTitle((TextConstruct)new PlainTextConstruct(string2));
        this.mainEntry = documentListEntry = (DocumentListEntry)this.getService().insert(new URL("https://docs.google.com/feeds/default/private/full/"), (IEntry)documentListEntry2);
        if (this.mainEntry != null) {
            return this.mainEntry.getHtmlLink().getHref();
        }
        return null;
    }

    private String overrideOnFile(String string, Spreadsheet spreadsheet) throws Exception {
        File file = new File(string);
        String string2 = DocumentListEntry.MediaType.fromFileName((String)file.getName()).getMimeType();
        DocumentListEntry documentListEntry = spreadsheet.getEntry();
        documentListEntry.setMediaSource((MediaSource)new MediaFileSource(file, string2));
        documentListEntry.setEtag("*");
        this.mainEntry = (DocumentListEntry)documentListEntry.updateMedia(true);
        return this.mainEntry.getHtmlLink().getHref();
    }

    public ArrayList<Spreadsheet> getSpreadsheetWithSameName(String string) {
        ArrayList<Spreadsheet> arrayList = new ArrayList<Spreadsheet>();
        try {
            URL uRL = new URL("https://docs.google.com/feeds/default/private/full/");
            DocumentListFeed documentListFeed = (DocumentListFeed)this.getService().getFeed(uRL, DocumentListFeed.class);
            for (DocumentListEntry documentListEntry : documentListFeed.getEntries()) {
                if (!documentListEntry.getType().equalsIgnoreCase("spreadsheet") || !documentListEntry.getTitle().getPlainText().equalsIgnoreCase(string)) continue;
                if (arrayList.size() == 0) {
                    arrayList.add(new Spreadsheet());
                }
                arrayList.add(new Spreadsheet(documentListEntry));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public void afterUpload() throws Exception {
        this.publishDocument();
    }

    @Override
    public void setUserCredentials(String string, String string2) throws AuthenticationException, CaptchaRequiredException {
        try {
            this.getService().setUserCredentials(string, string2);
        }
        catch (GoogleService.CaptchaRequiredException captchaRequiredException) {
            throw new CaptchaRequiredException(captchaRequiredException.getCaptchaToken(), captchaRequiredException.getCaptchaUrl());
        }
        catch (com.google.gdata.util.AuthenticationException authenticationException) {
            throw new AuthenticationException(authenticationException.getMessage());
        }
    }

    @Override
    public void setUserCredentials(String string, String string2, String string3, String string4) throws AuthenticationException, CaptchaRequiredException {
        try {
            this.getService().setUserCredentials(string, string2, string3, string4);
        }
        catch (GoogleService.CaptchaRequiredException captchaRequiredException) {
            throw new CaptchaRequiredException(captchaRequiredException.getCaptchaToken(), captchaRequiredException.getCaptchaUrl());
        }
        catch (com.google.gdata.util.AuthenticationException authenticationException) {
            throw new AuthenticationException(authenticationException.getMessage());
        }
    }

    @Override
    public String getServiceName() {
        return "Google Spreadsheet Service";
    }

    @Override
    public String getServiceDescription() {
        return "spshg.cls.google.description";
    }

    @Override
    public boolean isPolicyChangeable() {
        return true;
    }

    @Override
    public JDialog getPolicyEditorUI(JFrame jFrame) {
        return new ShareSettingDialog(jFrame);
    }

    @Override
    public String formatText(String string) {
        if (string.matches("\\s*\\d+\\Qe\\E\\d+\\s*")) {
            return "=TO_TEXT(\"\"" + string + "\"\")";
        }
        return string;
    }

    public synchronized AclEntry shareDocument(int n, int n2, String string) throws Exception {
        if (this.mainEntry == null) {
            throw new Exception();
        }
        AclRole aclRole = null;
        switch (n) {
            case 1: {
                aclRole = AclRole.OWNER;
                break;
            }
            case 3: {
                aclRole = AclRole.READER;
                break;
            }
            case 2: {
                aclRole = AclRole.WRITER;
            }
        }
        AclScope aclScope = null;
        switch (n2) {
            case 13: {
                aclScope = new AclScope(AclScope.Type.DEFAULT, null);
                break;
            }
            case 10: {
                aclScope = new AclScope(AclScope.Type.USER, string);
                break;
            }
            case 11: {
                aclScope = new AclScope(AclScope.Type.GROUP, string);
                break;
            }
            case 12: {
                aclScope = new AclScope(AclScope.Type.DOMAIN, string);
                break;
            }
            default: {
                throw new Exception("Scope Type is not correctly selected.");
            }
        }
        return this.addAclRole(aclRole, aclScope, this.mainEntry);
    }

    public synchronized void publishDocument() throws UploadException {
        try {
            RevisionFeed revisionFeed = this.getRevisionFeed();
            for (RevisionEntry revisionEntry : revisionFeed.getEntries()) {
                revisionEntry.setPublishAuto(Boolean.valueOf(true));
                revisionEntry.setPublish(Boolean.valueOf(true));
                revisionEntry = (RevisionEntry)revisionEntry.update();
            }
        }
        catch (Exception exception) {
            throw new UploadException(2, Util.I18N.getString("spshg.message.error.publish") + exception.getLocalizedMessage());
        }
    }

    public synchronized List<AclEntry> updateAclList() throws MalformedURLException, IOException, ServiceException {
        AclFeed aclFeed = (AclFeed)this.getService().getFeed(new URL(this.mainEntry.getAclFeedLink().getHref()), AclFeed.class);
        return aclFeed.getEntries();
    }

    public AclEntry updatePermission(AclEntry aclEntry, Users users) throws IOException, ServiceException {
        if (users.isVisibilityDescription()) {
            AclEntry aclEntry2 = new AclEntry();
            aclEntry2.setScope(new AclScope(GoogleSpreadSheetService.toGoogleScope(users.getScope()), null));
            if (users.getScope() != 14) {
                aclEntry2.setRole(GoogleSpreadSheetService.toGoogleRole(users.getPermissionType()));
            } else {
                aclEntry2.setWithKey(new AclWithKey("with link", GoogleSpreadSheetService.toGoogleRole(users.getPermissionType())));
            }
            aclEntry2.setPublished(DateTime.now());
            return (AclEntry)this.getService().insert(new URL(this.mainEntry.getAclFeedLink().getHref()), (IEntry)aclEntry2);
        }
        aclEntry.setRole(GoogleSpreadSheetService.toGoogleRole(users.getPermissionType()));
        return (AclEntry)aclEntry.update();
    }

    private synchronized AclEntry addAclRole(AclRole aclRole, AclScope aclScope, DocumentListEntry documentListEntry) throws IOException, MalformedURLException, ServiceException {
        AclEntry aclEntry = new AclEntry();
        aclEntry.setRole(aclRole);
        aclEntry.setScope(aclScope);
        aclEntry.setPublished(DateTime.now());
        return (AclEntry)this.getService().insert(new URL(documentListEntry.getAclFeedLink().getHref()), (IEntry)aclEntry);
    }

    private RevisionFeed getRevisionFeed() throws Exception {
        if (this.mainEntry == null) {
            throw new Exception();
        }
        URL uRL = new URL(this.mainEntry.getSelfLink().getHref() + "/revisions");
        RevisionFeed revisionFeed = (RevisionFeed)this.getService().getFeed(uRL, RevisionFeed.class);
        return revisionFeed;
    }

    public static int toLocalCode(AclScope.Type type) {
        if (type.equals((Object)AclScope.Type.DEFAULT)) {
            return 13;
        }
        if (type.equals((Object)AclScope.Type.USER)) {
            return 10;
        }
        if (type.equals((Object)AclScope.Type.GROUP)) {
            return 11;
        }
        if (type.equals((Object)AclScope.Type.DOMAIN)) {
            return 12;
        }
        return 0;
    }

    public static int toLocalCode(AclRole aclRole) {
        if (aclRole.equals((Object)AclRole.OWNER)) {
            return 1;
        }
        if (aclRole.equals((Object)AclRole.READER)) {
            return 3;
        }
        if (aclRole.equals((Object)AclRole.WRITER)) {
            return 2;
        }
        return 0;
    }

    public static AclScope.Type toGoogleScope(int n) {
        switch (n) {
            case 13: {
                return AclScope.Type.DEFAULT;
            }
            case 10: {
                return AclScope.Type.USER;
            }
            case 11: {
                return AclScope.Type.GROUP;
            }
            case 12: {
                return AclScope.Type.DOMAIN;
            }
            case 14: {
                return AclScope.Type.DEFAULT;
            }
        }
        return null;
    }

    public static AclRole toGoogleRole(int n) {
        switch (n) {
            case 1: {
                return AclRole.OWNER;
            }
            case 3: {
                return AclRole.READER;
            }
            case 2: {
                return AclRole.WRITER;
            }
        }
        return null;
    }
}

