/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.controller;

import java.io.File;
import java.io.FileOutputStream;
import org.citydb.api.controller.LogController;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.CSVColumns;
import org.citydb.plugins.spreadsheet_gen.gui.view.components.TableDataModel;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class TemplateWriter
implements Runnable {
    private String path;
    private TableDataModel tableDataModel;
    private String separatorPhrase;
    private final LogController logController;

    public TemplateWriter(String string, TableDataModel tableDataModel) {
        this.path = string;
        this.tableDataModel = tableDataModel;
        this.separatorPhrase = System.getProperty("line.separator");
        this.logController = ObjectRegistry.getInstance().getLogController();
    }

    @Override
    public void run() {
        File file = new File(this.path);
        if (!file.exists() && file.getParent() != null) {
            file.getParentFile().mkdirs();
        }
        int n = this.tableDataModel.getRowCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            CSVColumns cSVColumns = this.tableDataModel.getCSVColumn(i);
            if (cSVColumns.comment != null && cSVColumns.comment.trim().length() > 0) {
                if (i > 0) {
                    stringBuffer.append(this.separatorPhrase);
                }
                stringBuffer.append("// ");
                stringBuffer.append(cSVColumns.comment.replaceAll(this.separatorPhrase, this.separatorPhrase + "//"));
                stringBuffer.append(this.separatorPhrase);
            } else if (i > 0) {
                stringBuffer.append(this.separatorPhrase);
            }
            stringBuffer.append(cSVColumns.title);
            stringBuffer.append(":");
            stringBuffer.append(cSVColumns.textcontent);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(stringBuffer.toString().getBytes("UTF-8"));
            fileOutputStream.flush();
            fileOutputStream.close();
            this.logController.info(Util.I18N.getString("spshg.message.save.template.success") + System.getProperty("line.separator") + this.path);
        }
        catch (Exception exception) {
            this.logController.error(Util.I18N.getString("spshg.message.save.template.failed") + exception.getMessage());
        }
    }
}

