/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.controller;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.citydb.api.concurrent.PoolSizeAdaptationStrategy;
import org.citydb.api.concurrent.SingleWorkerPool;
import org.citydb.api.concurrent.WorkerFactory;
import org.citydb.api.concurrent.WorkerPool;
import org.citydb.api.controller.LogController;
import org.citydb.api.event.Event;
import org.citydb.api.event.EventDispatcher;
import org.citydb.api.event.EventHandler;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.config.project.database.Workspace;
import org.citydb.database.DatabaseConnectionPool;
import org.citydb.plugins.spreadsheet_gen.concurrent.CSVWriter;
import org.citydb.plugins.spreadsheet_gen.concurrent.SPSHGWorker;
import org.citydb.plugins.spreadsheet_gen.concurrent.SPSHGWorkerFactory;
import org.citydb.plugins.spreadsheet_gen.concurrent.UploadFileFactory;
import org.citydb.plugins.spreadsheet_gen.concurrent.WriterFactory;
import org.citydb.plugins.spreadsheet_gen.concurrent.work.CityObjectWork;
import org.citydb.plugins.spreadsheet_gen.concurrent.work.RowofCSVWork;
import org.citydb.plugins.spreadsheet_gen.concurrent.work.UploadFileWork;
import org.citydb.plugins.spreadsheet_gen.config.ConfigImpl;
import org.citydb.plugins.spreadsheet_gen.database.DBManager;
import org.citydb.plugins.spreadsheet_gen.database.Translator;
import org.citydb.plugins.spreadsheet_gen.events.EventType;
import org.citydb.plugins.spreadsheet_gen.events.InterruptEvent;
import org.citydb.plugins.spreadsheet_gen.events.StatusDialogTitle;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.SelectedCityObjects;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.SeparatorPhrase;
import org.citydb.plugins.spreadsheet_gen.gui.view.SPSHGPanel;
import org.citydb.plugins.spreadsheet_gen.spsheet_gen;
import org.citydb.util.Util;

public class SpreadsheetExporter
implements EventHandler {
    private final DatabaseConnectionPool dbPool;
    private final spsheet_gen plugin;
    private final EventDispatcher eventDispatcher;
    private final LogController logController;
    private volatile boolean shouldRun = true;
    private AtomicBoolean isInterrupted = new AtomicBoolean(false);
    private WorkerPool<CityObjectWork> workerPool;
    private SingleWorkerPool<RowofCSVWork> ioWriterPool;
    private SingleWorkerPool<UploadFileWork> uploaderPool;
    private DBManager dbm = null;

    public SpreadsheetExporter(spsheet_gen spsheet_gen2) {
        this.plugin = spsheet_gen2;
        this.dbPool = DatabaseConnectionPool.getInstance();
        this.eventDispatcher = ObjectRegistry.getInstance().getEventDispatcher();
        this.logController = ObjectRegistry.getInstance().getLogController();
    }

    public void cleanup() {
        this.eventDispatcher.removeEventHandler((EventHandler)this);
    }

    public boolean doProcess() {
        this.eventDispatcher.addEventHandler((Enum)EventType.INTERRUPT, (EventHandler)this);
        ConfigImpl configImpl = this.plugin.getConfig();
        int n = 2;
        int n2 = 10;
        File file = null;
        if (!configImpl.getTemplate().isManualTemplate() && !(file = new File(configImpl.getTemplate().getPath())).isFile()) {
            this.logController.error(org.citydb.plugins.spreadsheet_gen.util.Util.I18N.getString("spshg.message.export.template.notavailable"));
            return false;
        }
        Workspace workspace = configImpl.getWorkspace();
        if (this.shouldRun && this.dbPool.getActiveDatabaseAdapter().hasVersioningSupport() && !this.dbPool.getActiveDatabaseAdapter().getWorkspaceManager().equalsDefaultWorkspaceName(workspace.getName()) && !this.dbPool.getActiveDatabaseAdapter().getWorkspaceManager().existsWorkspace(workspace, true)) {
            return false;
        }
        String string = "";
        String string2 = "";
        UploadFileWork uploadFileWork = null;
        if (configImpl.getOutput().getType() == "INTOCLOUD") {
            string2 = System.getProperty("java.io.tmpdir");
            string = configImpl.getOutput().getCloud().getSpreadsheetName();
            uploadFileWork = new UploadFileWork(string2 == null ? "" : string2 + string + ".xlsx", configImpl.getOutput().getCloud().getSpreadsheetName());
        } else {
            string2 = configImpl.getOutput().getType() == "XLSX_FILE" ? configImpl.getOutput().getXlsxfile().getOutputPath().trim() : configImpl.getOutput().getCsvfile().getOutputPath().trim();
            if (string2.lastIndexOf(File.separator) == -1) {
                string = string2;
                string2 = ".";
            } else {
                string = string2.lastIndexOf(".") == -1 ? string2.substring(string2.lastIndexOf(File.separator) + 1) : string2.substring(string2.lastIndexOf(File.separator) + 1, string2.lastIndexOf("."));
                string2 = string2.substring(0, string2.lastIndexOf(File.separator));
            }
        }
        String string3 = string2 + File.separator + string + ".csv";
        if (configImpl.getOutput().getType().equalsIgnoreCase("XLSX_FILE") || configImpl.getOutput().getType().equalsIgnoreCase("INTOCLOUD")) {
            string3 = System.getProperty("java.io.tmpdir") + File.separator + string + ".csv";
        }
        File file2 = new File(string3);
        File file3 = null;
        file3 = configImpl.getOutput().getType() == "XLSX_FILE" ? new File(string2 + File.separator + string + ".xlsx") : new File(string2 + File.separator + string + ".csv");
        if (!file3.exists()) {
            try {
                file3.createNewFile();
            }
            catch (Exception exception) {
                this.logController.error(org.citydb.plugins.spreadsheet_gen.util.Util.I18N.getString("spshg.message.export.file.error"));
                return false;
            }
        }
        this.ioWriterPool = new SingleWorkerPool("spsh_writer_pool", (WorkerFactory)new WriterFactory(file2), 100, true);
        String string4 = "";
        try {
            string4 = !configImpl.getTemplate().isManualTemplate() ? Translator.getInstance().translateToBalloonTemplate(new File(configImpl.getTemplate().getPath())) : Translator.getInstance().translateToBalloonTemplate(configImpl.getTemplate().getColumnsList());
        }
        catch (Exception exception) {
            this.logController.error(org.citydb.plugins.spreadsheet_gen.util.Util.I18N.getString("spshg.message.export.file.error.reading"));
            return false;
        }
        this.workerPool = new WorkerPool("spsh_generator_pool", n, n2, PoolSizeAdaptationStrategy.AGGRESSIVE, (WorkerFactory)new SPSHGWorkerFactory(this.dbPool, (WorkerPool<RowofCSVWork>)this.ioWriterPool, configImpl, string4), 300, false);
        this.workerPool.setContextClassLoader(SpreadsheetExporter.class.getClassLoader());
        this.ioWriterPool.prestartCoreWorkers();
        this.workerPool.prestartCoreWorkers();
        String string5 = configImpl.getOutput().getType().equalsIgnoreCase("INTOCLOUD") ? SeparatorPhrase.getInstance().getIntoCloudDefaultSeperator() : SeparatorPhrase.getInstance().decode(configImpl.getOutput().getCsvfile().getSeparator().trim());
        this.ioWriterPool.addWork((Object)new RowofCSVWork(SPSHGWorker.generateHeader(Translator.getInstance().getColumnTitle(), string5), -1));
        CSVWriter.resetLogStorage();
        try {
            this.dbm = new DBManager(this.dbPool, configImpl, this.workerPool);
            SPSHGWorker.counter = 0L;
            this.eventDispatcher.triggerEvent((Event)new StatusDialogTitle(org.citydb.plugins.spreadsheet_gen.util.Util.I18N.getString("spshg.dialog.status.state.generating"), this));
            if (this.shouldRun) {
                this.dbm.startQuery(SelectedCityObjects.getInstance().getSelectedCityObjects());
            }
        }
        catch (SQLException sQLException) {
            this.logController.error("SQL error: " + sQLException.getMessage());
            return false;
        }
        try {
            if (this.shouldRun) {
                this.workerPool.shutdownAndWait();
            }
            this.ioWriterPool.shutdownAndWait();
        }
        catch (InterruptedException interruptedException) {
            this.logController.error(org.citydb.plugins.spreadsheet_gen.util.Util.I18N.getString("common.error") + interruptedException.getMessage());
            this.shouldRun = false;
        }
        if (configImpl.getOutput().getType().equalsIgnoreCase("XLSX_FILE") || configImpl.getOutput().getType().equalsIgnoreCase("INTOCLOUD")) {
            try {
                this.convertToXSLX(string3, string2, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.shouldRun) {
            this.writeReport();
        }
        if (configImpl.getOutput().getType() == "INTOCLOUD") {
            this.uploaderPool = new SingleWorkerPool("spsh_upload_pool", (WorkerFactory)new UploadFileFactory(), 10);
            this.uploaderPool.setContextClassLoader(SPSHGPanel.class.getClassLoader());
            this.uploaderPool.prestartCoreWorkers();
            try {
                if (this.shouldRun) {
                    this.uploaderPool.addWork((Object)uploadFileWork);
                }
                this.uploaderPool.shutdownAndWait();
            }
            catch (InterruptedException interruptedException) {
                this.logController.error(org.citydb.plugins.spreadsheet_gen.util.Util.I18N.getString("common.error") + interruptedException.getMessage());
                this.shouldRun = false;
            }
        }
        return this.shouldRun;
    }

    public void handleEvent(Event event) throws Exception {
        if (this.isInterrupted.compareAndSet(false, true)) {
            this.shouldRun = false;
            if (this.dbm != null) {
                this.dbm.shutdown();
            }
            if (this.workerPool != null) {
                this.workerPool.shutdownNow();
            }
            this.logController.log(((InterruptEvent)event).getLogLevelType(), ((InterruptEvent)event).getLogMessage());
        }
    }

    public void writeReport() {
        HashMap<Integer, AtomicInteger> hashMap = CSVWriter.getRportStructure();
        StringBuffer stringBuffer = new StringBuffer();
        this.logController.info(org.citydb.plugins.spreadsheet_gen.util.Util.I18N.getString("spshg.message.summery.title"));
        int n = 0;
        for (Integer n2 : hashMap.keySet()) {
            stringBuffer.append(SelectedCityObjects.getInstance().getCityObjectName(Util.classId2cityObject((int)n2)));
            stringBuffer.append(": ");
            stringBuffer.append(hashMap.get(n2).intValue());
            this.logController.info(stringBuffer.toString());
            stringBuffer.setLength(0);
            n += hashMap.get(n2).intValue();
        }
        this.logController.info(String.format(org.citydb.plugins.spreadsheet_gen.util.Util.I18N.getString("spshg.message.summery.sumery"), n));
    }

    public void convertToXSLX(String string, String string2, String string3) throws Exception {
        Object object;
        XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();
        Sheet sheet = xSSFWorkbook.createSheet("Countries");
        CsvReader csvReader = null;
        int n = 0;
        String string4 = string2 + File.separator + string3 + ".xlsx";
        csvReader = new CsvReader(string, SeparatorPhrase.getInstance().getIntoCloudDefaultSeperator().charAt(0), Charset.forName("UTF-8"));
        csvReader.setSafetySwitch(false);
        csvReader.readRecord();
        String[] stringArray = csvReader.getValues();
        Row row = sheet.createRow(n);
        for (int i = 0; i < stringArray.length; ++i) {
            object = row.createCell(i);
            object.setCellValue(stringArray[i]);
        }
        ++n;
        Map<String, String> map = Translator.getInstance().getTemplateHashmap();
        try {
            while (csvReader.readRecord()) {
                row = sheet.createRow(n);
                object = csvReader.getValues();
                if (object == null || ((String[])object).length <= 0) continue;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (object[i] == null || String.valueOf(((String)object[i]).trim()).length() <= 0) continue;
                    String string5 = map.get(stringArray[i]);
                    Cell cell = row.createCell(i);
                    int n2 = org.citydb.plugins.spreadsheet_gen.util.Util._3DCITYDB_TABLES_AND_COLUMNS.get(string5);
                    if (n2 == org.citydb.plugins.spreadsheet_gen.util.Util.NUMBER_COLUMN_VALUE) {
                        try {
                            cell.setCellValue(Double.valueOf((String)object[i]).doubleValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            cell.setCellValue(String.valueOf(object[i]));
                        }
                        continue;
                    }
                    cell.setCellValue(String.valueOf(object[i]));
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        csvReader.close();
        object = null;
        try {
            object = new FileOutputStream(new File(string4));
            xSSFWorkbook.write((OutputStream)object);
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            this.logController.error(iOException.getMessage());
            this.shouldRun = false;
        }
    }
}

