/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.concurrent;

import org.citydb.api.concurrent.DefaultWorkerImpl;
import org.citydb.api.controller.LogController;
import org.citydb.api.event.Event;
import org.citydb.api.event.EventDispatcher;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.plugins.spreadsheet_gen.concurrent.work.UploadFileWork;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.CloudServiceRegistery;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.UploadException;
import org.citydb.plugins.spreadsheet_gen.events.StatusDialogMessage;
import org.citydb.plugins.spreadsheet_gen.events.StatusDialogTitle;
import org.citydb.plugins.spreadsheet_gen.events.UploadEvent;
import org.citydb.plugins.spreadsheet_gen.util.Util;

public class UploadFileWorker
extends DefaultWorkerImpl<UploadFileWork> {
    public static final String URL = "URL_INTO_CLOUD";
    private final EventDispatcher eventDispatcher = ObjectRegistry.getInstance().getEventDispatcher();
    private final LogController logController = ObjectRegistry.getInstance().getLogController();

    public void doWork(UploadFileWork uploadFileWork) {
        this.eventDispatcher.triggerEvent((Event)new StatusDialogTitle(Util.I18N.getString("spshg.dialog.status.state.upload"), (Object)this));
        this.eventDispatcher.triggerEvent((Event)new StatusDialogMessage("Title: " + uploadFileWork.getTitle(), (Object)this));
        String string = "";
        try {
            string = this.uploadFile(uploadFileWork.getLocalpath(), uploadFileWork.getTitle());
            this.eventDispatcher.triggerEvent((Event)new StatusDialogMessage(uploadFileWork.getTitle() + " " + Util.I18N.getString("spshg.dialog.status.state.upload.done"), (Object)this));
            this.logController.info(Util.I18N.getString("spshg.message.upload.done.success") + (string == null ? "" : " Address:" + string));
            CloudServiceRegistery.getInstance().getSelectedService().afterUpload();
            this.eventDispatcher.triggerEvent((Event)new UploadEvent(true, string, (Object)this));
        }
        catch (Exception exception) {
            if (exception instanceof UploadException) {
                switch (((UploadException)exception).getType()) {
                    case 2: {
                        this.logController.error(exception.getMessage());
                        this.eventDispatcher.triggerEvent((Event)new UploadEvent(true, string, (Object)this));
                        return;
                    }
                }
            }
            this.logController.error(Util.I18N.getString("spshg.message.upload.done.fail") + exception.getMessage());
            this.eventDispatcher.triggerEvent((Event)new UploadEvent(false, null, (Object)this));
        }
    }

    private String uploadFile(String string, String string2) throws Exception {
        if (string == null) {
            return null;
        }
        return CloudServiceRegistery.getInstance().getSelectedService().uploadFile(string, string2);
    }

    public void shutdown() {
    }
}

