/*
 * Decompiled with CFR 0.152.
 */
package org.citydb.plugins.spreadsheet_gen.concurrent;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.citydb.api.concurrent.DefaultWorkerImpl;
import org.citydb.api.concurrent.WorkerPool;
import org.citydb.api.database.BalloonTemplateHandler;
import org.citydb.api.event.Event;
import org.citydb.api.event.EventDispatcher;
import org.citydb.api.registry.ObjectRegistry;
import org.citydb.database.DatabaseConnectionPool;
import org.citydb.modules.common.balloon.BalloonTemplateHandlerImpl;
import org.citydb.plugins.spreadsheet_gen.concurrent.work.CityObjectWork;
import org.citydb.plugins.spreadsheet_gen.concurrent.work.RowofCSVWork;
import org.citydb.plugins.spreadsheet_gen.config.ConfigImpl;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.CloudService;
import org.citydb.plugins.spreadsheet_gen.controller.cloudservice.CloudServiceRegistery;
import org.citydb.plugins.spreadsheet_gen.events.StatusDialogMessage;
import org.citydb.plugins.spreadsheet_gen.gui.datatype.SeparatorPhrase;

public class SPSHGWorker
extends DefaultWorkerImpl<CityObjectWork> {
    private final WorkerPool<RowofCSVWork> ioWriterPool;
    private BalloonTemplateHandler bth;
    private Connection connection;
    private String seperatorCharacter;
    private int lod;
    public static long counter = 0L;
    private final EventDispatcher eventDispatcher = ObjectRegistry.getInstance().getEventDispatcher();
    private CloudService selectedCloudService = null;
    private boolean shouldRun;

    public SPSHGWorker(DatabaseConnectionPool databaseConnectionPool, WorkerPool<RowofCSVWork> workerPool, ConfigImpl configImpl, String string) throws SQLException {
        this.ioWriterPool = workerPool;
        this.connection = databaseConnectionPool.getConnection();
        String string2 = configImpl.getWorkspace().getTimestamp();
        if (databaseConnectionPool.getActiveDatabaseAdapter().hasVersioningSupport()) {
            databaseConnectionPool.getActiveDatabaseAdapter().getWorkspaceManager().gotoWorkspace(this.connection, configImpl.getWorkspace());
        }
        this.seperatorCharacter = configImpl.getOutput().getType().equalsIgnoreCase("INTOCLOUD") || configImpl.getOutput().getType().equalsIgnoreCase("XLSX_FILE") ? SeparatorPhrase.getInstance().getIntoCloudDefaultSeperator() : SeparatorPhrase.getInstance().decode(configImpl.getOutput().getCsvfile().getSeparator().trim());
        this.selectedCloudService = configImpl.getOutput().getType() == "INTOCLOUD" ? CloudServiceRegistery.getInstance().getSelectedService() : null;
        this.shouldRun = true;
        this.bth = new BalloonTemplateHandlerImpl(string, this.connection);
        this.lod = 2;
    }

    public void doWork(CityObjectWork cityObjectWork) {
        try {
            if (!this.shouldRun) {
                return;
            }
            String string = this.bth.getBalloonContent(cityObjectWork.getGmlid(), this.lod);
            String[] stringArray = string.split("\\Q" + SeparatorPhrase.getInstance().getTempPhrase() + "\\E");
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (String string2 : stringArray) {
                if (!bl) {
                    stringBuffer.append(this.seperatorCharacter);
                    stringBuffer.append("\"");
                } else {
                    stringBuffer.append('\"');
                    bl = false;
                }
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            }
            stringBuffer.append("\r\n");
            this.ioWriterPool.addWork((Object)new RowofCSVWork(stringBuffer.toString(), cityObjectWork.getClassid()));
            this.eventDispatcher.triggerEvent((Event)new StatusDialogMessage(" " + ++counter, (Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shouldRun = false;
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public static String generateHeader(ArrayList<String> arrayList, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string2 : arrayList) {
            if (!bl) {
                stringBuffer.append(string);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append('\"');
                bl = false;
            }
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }
}

