/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimpleFinishPanel
extends IzPanel {
    private static final long serialVersionUID = 3689911781942572085L;
    private VariableSubstitutor vs;

    public SimpleFinishPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, new GridBagLayout());
        this.vs = new VariableSubstitutor(installData.getVariables());
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.parent.langpack.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        if (this.idata.installSuccess) {
            JLabel jLabel = LabelFactory.create(this.parent.langpack.getString("FinishPanel.success"), this.parent.icons.getImageIcon("check"), 10);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(20, 0, 0, 0);
            jPanel.add((Component)jLabel, gridBagConstraints);
            if (this.idata.uninstallOutJar != null) {
                String string = this.translatePath(this.idata.info.getUninstallerPath());
                JLabel jLabel2 = LabelFactory.create(this.parent.langpack.getString("FinishPanel.uninst.info"), this.parent.icons.getImageIcon("preferences"), 10);
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(20, 0, 0, 0);
                jPanel.add((Component)jLabel2, gridBagConstraints);
                JLabel jLabel3 = LabelFactory.create(string, this.parent.icons.getImageIcon("empty"), 10);
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)jLabel3, gridBagConstraints);
            }
        } else {
            JLabel jLabel = LabelFactory.create(this.parent.langpack.getString("FinishPanel.fail"), this.parent.icons.getImageIcon("stop"), 10);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(30, 0, 0, 0);
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        this.getLayoutHelper().completeLayout();
        Log.getInstance().informUser();
    }

    private String translatePath(String string) {
        string = this.vs.substitute(string, null);
        return string.replace('/', File.separatorChar);
    }
}

