/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicencePanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3691043187997552948L;
    private String licence;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;

    public LicencePanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, new IzPanelLayout());
        this.loadLicence();
        this.add((Component)LabelFactory.create(installerFrame.langpack.getString("LicencePanel.info"), installerFrame.icons.getImageIcon("history"), 10), "nextLine");
        JTextArea jTextArea = new JTextArea(this.licence);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setAlignmentX(0.0f);
        this.add((Component)jScrollPane, "nextLine");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.yesRadio = new JRadioButton(installerFrame.langpack.getString("LicencePanel.agree"), false);
        buttonGroup.add(this.yesRadio);
        this.add((Component)this.yesRadio, "nextLine");
        this.yesRadio.addActionListener(this);
        this.noRadio = new JRadioButton(installerFrame.langpack.getString("LicencePanel.notagree"), true);
        buttonGroup.add(this.noRadio);
        this.add((Component)this.noRadio, "nextLine");
        this.noRadio.addActionListener(this);
        this.setInitialFocus(this.noRadio);
        this.getLayoutHelper().completeLayout();
    }

    private void loadLicence() {
        Charset charset;
        try {
            charset = Charset.forName("UTF-8");
        }
        catch (Exception exception) {
            charset = Charset.defaultCharset();
        }
        try {
            String string = "LicencePanel.licence";
            this.licence = new String(ResourceManager.getInstance().getTextResource(string).getBytes(), charset);
        }
        catch (Exception exception) {
            this.licence = "Error : could not load the licence text !";
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

